<?php
define('CF_WELCOME_CLASS','welcome');
define('CF_ERROR_CLASS', 'error');
define('CF_SUCCESS_CLASS','error');

class contactForm{

	var $system_mail_from='';
	var $system_mail_to='';
	var $system_mail_subjectprefix='[Contact form]';
	var $system_mail_replytouser=false;
	var $system_validate_MX=false;
	var $system_validate_MX_WINDOZ=false;
	var $system_url='';
	var $system_whois_url='';
	
	var $system_submit_limit_enabled=false;
	var $system_submit_limit_expire=10; //minutes
	var $system_submit_limit_value=3; //submits
	var $system_submit_limit_error = "Hey! That's enough contact for me, how about we slow down?";	

	var $header_title='Contact me.';
	var $header_meta='';

	var $form_name_label='Name:';
	var $form_email_label='Email:';
	var $form_message_label='Message:';
	var $form_submit_label='Submit';
	
	var $form_name_value='';
	var $form_email_value='';
	var $form_message_value='';

	var $page_title='Welcom to my contact page.';
	var $page_subtitle='I\'m just a click away----------------->';

	var $form_status_welcome='Welcome to my contact page. <br />You can send me mail using this form:';
	var $form_status_success='Good work! Your message was sent.';
	var $form_status_error_validate='Oops! There was a problem. Do you want to try again?';
	var $form_status_error_MXvalidate='We checked that address and couldn\'t find a server. Do you want to try again?';
	var $form_status_error_send='Oops! There was a problem with the server. Do you want to try again?';

	var $form_status=''; //variable to hold the current status message
	var $form_status_class='';	//hold the current status message CSS class

	var $theme_path='themes/default/';

	function initConfig($configFile='config.inc.php'){
		require($configFile);
		
		$this->system_mail_from=$system_mail_from;
		$this->system_mail_to=$system_mail_to;
		$this->system_mail_subjectprefix=$system_mail_subjectprefix;
		$this->system_mail_replytouser=$system_mail_replytouser;
		$this->system_validate_MX=$system_validate_MX;
		$this->system_validate_MX_WINDOZ=$system_validate_MX_WINDOZ;
		$this->system_url=$system_url;
		$this->system_whois_url=$system_whois_url;
		
		$this->system_submit_limit_enabled=$system_submit_limit_enabled;
		$this->system_submit_limit_expire=$system_submit_limit_expire;
		$this->system_submit_limit_value=$system_submit_limit_value;
		$this->system_submit_limit_error=$system_submit_limit_error;
		
		$this->header_title=$header_title;
		$this->header_meta=$header_meta;
		
		$this->page_title=$page_title;
		$this->page_subtitle=$page_subtitle;
		
		$this->form_name_label=$form_name_label;
		$this->form_email_label=$form_email_label;
		$this->form_message_label=$form_message_label;
		$this->form_submit_label=$form_submit_label;
	
		$this->form_status_welcome=$form_status_welcome;
		$this->form_status_success=$form_status_success;
		$this->form_status_error_validate=$form_status_error_validate;
		$this->form_status_error_MXvalidate=$form_status_error_MXvalidate;
		$this->form_status_error_send=$form_status_error_send;

		$this->theme_path=$theme_base.$theme_directory;
		$this->theme_title_color=$theme_title_color;	

		//start the session if enabled		
		if($this->system_submit_limit_enabled){$this->submit_limit_init();}
	}
	
	function process(){
		if(!isset($_POST['submit']) || !isset($_POST['Name']) || !isset($_POST['Email']) || !isset($_POST['Message'])){ 
			//show normal page stuff
			$this->form_status=$this->form_status_welcome;
			$this->form_status_class=CF_WELCOME_CLASS;
		}else{//only if form was submitted....
			
			//put the post values into the class
			$this->getFormValues($_POST['Name'], $_POST['Email'], $_POST['Message']);
			
			// validate the email address -- always check form, optionally verify MX record
			if(!$this->validateEmail($this->form_email_value)){	//simple address validation error
				$this->form_status=$this->form_status_error_validate; 	//error validating the email address
				$this->form_status_class=CF_ERROR_CLASS;
				$this->form_email_class=CF_ERROR_CLASS; //email error, highlight email
			}elseif($this->system_validate_MX && (!$this->validateEmailMX($this->form_email_value, $this->system_validate_MX_WINDOZ))){ //we checked and couldn't contact the server
				//mx RECORD ERROR
				$this->form_status=$this->form_status_error_MXvalidate; //we checked and couldn't contact the server
				$this->form_status_class=CF_ERROR_CLASS;
				$this->form_email_class=CF_ERROR_CLASS; //email error, highligh email
			}elseif($this->system_submit_limit_enabled && $this->submit_limit_check() ){
				//session based limiter enabled, throw an error.....
				$this->form_status=$this->system_submit_limit_error;
				$this->form_status_class=CF_ERROR_CLASS;
			}else{//send email 
				//build the email
				$em=$this->buildEmail();
				//attempt to send it
				if(!$this->sendEmail($em)){
					//error sending mail
					$this->form_status=$this->form_status_error_send;
					$this->form_status_class=CF_ERROR_CLASS;	
				}else{
					//success
					$this->form_status=$this->form_status_success;
					$this->form_status_class=CF_SUCCESS_CLASS;
					
					//clear the values
					$this->form_name_value='';
					$this->form_email_value='';
					$this->form_message_value='';
					
					//if enabled, increment the limiter
					if($this->system_submit_limit_enabled){$this->submit_limit_increment();}
				}
			}
		}
	}
	
	function redirect($u){
		//forwarding (404 and protect class...)
		Header( "HTTP/1.1 301 Moved Permanently" );
		Header( "Location: ".$u );
	}
	
	function submit_limit_session_defaults() {
		$_SESSION['submits'] = 0;
		$_SESSION['ip'] = md5($_SERVER['REMOTE_ADDR']);
		$_SESSION['start']=time();		
	}	

	function submit_limit_init(){
		session_start(); 
		if( !(isset($_SESSION['ip'])&&isset($_SESSION['start'])&&isset($_SESSION['submits'])) ){//new user, no session...
			$this->submit_limit_session_defaults();
		}elseif( $_SESSION['start'] < (time()-($this->system_submit_limit_expire*60)) ){//has enough time past
			$this->submit_limit_session_defaults();
		}elseif( !(md5($_SERVER['REMOTE_ADDR'])==$_SESSION['ip']) ){//we can verify the user like this....
			$this->submit_limit_session_defaults();
		}
	}
	
	function submit_limit_check(){return (($_SESSION['submits']+1) > $this->system_submit_limit_value);}
	
	function submit_limit_increment(){$_SESSION['submits']++;}

	//WINDOZ option attempts lookup on incompatable windows servers without checkdnsrr()
	//see: http://www.sitepoint.com/article/users-email-address-php
	function myCheckDNSRR($hostName, $recType = ''){
	 if(!empty($hostName)) {
	   if( $recType == '' ) $recType = "MX";
	   exec("nslookup -type=$recType $hostName", $result);
	   // check each line to find the one that starts with the host
	   // name. If it exists then the function succeeded.
	   foreach ($result as $line) {
		 if(eregi("^$hostName",$line)) {
		   return true;
		 }
	   }
	   // otherwise there was no mail handler for the domain
	   return false;
	 }
	 return false;
	}

	function validateEmailMX($em, $alternateLookup=false){
		//if($doMX){$doCheck=true;} 		//enforce proper form check if doing MX check to avoid errors.
		//test the mx record for the domain, if configured.
		// take a given email address and split it into the username and domain.
		list($userName, $mailDomain) = split("@", $em);
	
		//test that the domain exists
		if($alternateLookup){
			//windoz option
			if(!$this->myCheckDNSRR($mailDomain,"MX")){return false;}	
		}else{
			//linux option
			if(!checkdnsrr($mailDomain,"MX")){return false;}
		}
		
		//MX record successfully read
		return true;
	}

	function validateEmail($em){
		//make sure the mail isn't empty
		if(empty($em)){return false;} 	
			
		//be sure it is something @ domain . something, if configured
		if(!filter_var($em, FILTER_VALIDATE_EMAIL)){return false;}
	
		//email successfully verified
		return true;
	}
	
	function getFormValues($n, $e, $m){
		//get values, strip out the junk
		$this->form_name_value=Trim(stripslashes($n));
		$this->form_email_value=Trim(stripslashes($e));
		$this->form_message_value=Trim(stripslashes($m));
	}		

	function sendEmail($em){return mail($this->system_mail_to, $em['subject'], $em['body'], $em['headers']);}
	
	function buildEmail(){
		$em=array("headers"=>"","subject"=>"","body"=>"");
	
		//prepare header, optional reply-to: header
		$em['headers'] = 'From: <'.$this->system_mail_from.'>' . "\r\n";
		if($this->system_mail_replytouser){$em['headers'] .= 'Reply-To: <'.$this->form_email_value.'>'."\r\n";}
		$em['headers'] .= 'X-Mailer: SimpleContact/PHP: ' . phpversion();

		//make subject, include optional subjectprefix
		$em['subject'] = $this->system_mail_subjectprefix.$this->form_name_value;

		//make email body text
		//Contact form submission from XXXXXXX"
		//Author : XXX (IP: XXX , domain)
		//E-mail : XXX
		//Whois  : $system_whois_urlXXXXX
		//Comment: 
		$em['body'] = 'Contact form submission from '.$this->page_title."\n";
		$em['body'] .= $this->form_name_label.' '.$this->form_name_value.' (IP: '.$_SERVER['REMOTE_ADDR'].' , '.gethostbyaddr($_SERVER['REMOTE_ADDR']).' )'."\n";
		$em['body'] .= $this->form_email_label.' '.$this->form_email_value."\n";
		$em['body'] .= 'Whois: '.$this->system_whois_url.$_SERVER['REMOTE_ADDR']."\n";
		$em['body'] .= $this->form_message_label."\n".$this->form_message_value."\n";
		
		return $em;
	}

	function write_contact_form(){
		?>
		<form method="post" action="" onSubmit="return email()">
			<label for="Name" id="Name"><?php echo $this->form_name_label;?></label>
			<input name="Name" type="text" value="<?php echo $this->form_name_value;?>" />
			
			<label for="Email" id="Email" class="<?php echo $this->form_email_class; ?>"><?php echo $this->form_email_label;?></label>
			<input type="text" name="Email" id="EmailInput" class="<?php echo $this->form_email_class; ?>" value="<?php echo $this->form_email_value;?>"/>
			   
			<label for="Message" id="Message"><?php echo $this->form_message_label;?></label><br />
			<textarea name="Message" rows="20" cols="20"><?php echo $this->form_message_value;?></textarea>
		
			<input type="submit" name="submit" value="<?php echo $this->form_submit_label;?>" class="submit-button" />
		</form>
		<?php
	}
	
	//form filling functions (all public)
	function write_header_title(){echo $this->header_title;}
	function write_header_meta(){echo $this->header_meta;}
	function write_page_title(){echo $this->page_title;}
	function write_page_subtitle(){echo $this->page_subtitle;}	
	function write_form_status(){echo $this->form_status;}
	function write_form_status_class(){echo $this->form_status_class;}
	function write_js(){require('js.js');}
	function write_css(){
		require($this->theme_path.'config.theme.php');
		require($this->theme_path.'css.css');
	}	
}

?>