<?php
require('config.inc.php');
if(!$admin_enabled){echo 'Administration disabled. Please check the configuration file.'; exit;}

function session_defaults() {
		$_SESSION['logged'] = false;
		$_SESSION['ip'] = '';
}	

function check_login($us,$ps){
	if (!isset($_SESSION['ip']) ) {session_defaults();} 
	if (!$_SESSION['logged']){
		if(isset($_POST['login']) && isset($_POST['user']) && isset($_POST['passwd'])){
			//check login credentials
			if(($_POST['user']==$us) && (md5($_POST['passwd'])==$ps)){
				$_SESSION['logged']=true;
				$_SESSION['ip']=md5($_SERVER['REMOTE_ADDR']);
				return true;		
			}else{
				echo 'Bad login <a href="admin.php">try again</a>.';
				exit;
			}
		}else{
			echo '<html><body>
			<div><br/>
			<center><b>You must login to use this function.</b><br/>
			<form name="form1" id="form1" method="post" action="">
			  Username: <input name="user" type="text" id="user" /><br/>
			  Password: <input name="passwd" type="password" id="passwd" /><br/>  
			  <input type="submit" name="login" value="login" />
			</form>
			</center>
			</div>
			</body></html>';
			exit;
		}	
	}else{//logged is true, check IP match
		if(md5($_SERVER['REMOTE_ADDR'])==$_SESSION['ip']){
			return true;
		}else{
			session_defaults();
			exit;
		}		
	}
}

//admin login tasks
session_start(); 
if(isset($_GET['logout'])||isset($_POST['logout'])){session_defaults();}
$log=check_login($admin_user,$admin_password);


//config file parsing stuff....
define('ROOTDIR', dirname(__FILE__));
define('LIBDIR', ROOTDIR);
define('CONFIG_FILE', ROOTDIR.'/config.inc.php');
//define('CE_NEWLINE', "\r\n"); //disable or it compounds the line breaks every time
define('CE_WORDWRAP', 500); //or it will split lines really bad
require_once(LIBDIR.'/confedit.class.php');
$config = new ConfigEditor(); // Creating an instance of ConfigEditor
//$config->LoadFromFile(CONFIG_FILE); 
/*
$var = $config->GetVar($var_name);
$var now is an array of the following structure:
	$var[CE_VARNAME] - holds variable name
	$var[CE_VARVALUE] - holds the value
	$var[CE_VARCOMMENT] - holds the comment associated with the variable
*/

$arr= array(
	array("des"=>"System configuration options","type"=>"break"),
	"system_mail_from"=> array("des"=>"The address contact mails come from:","type"=>"text"),
	"system_mail_to"=> array("des"=>"Where contact mails are sent:","type"=>"text"),
	"system_mail_subjectprefix"=> array("des"=>"Optional header prefix for contact form mail:","type"=>"text"),
	"system_mail_replytouser"=> array("des"=>"Reply to submitter's address? (not sent by some servers, marked as spam by some email)","type"=>"tf"),
	"system_validate_MX"=> array("des"=>"Verify mail server exists for @domain.tld:","type"=>"tf"),
	"system_validate_MX_WINDOZ"=> array("des"=>"Verify mail server from a Windows box? (alternate lookup method)","type"=>"tf"),
	"system_url"=> array("des"=>"System address for 404 redirects (.htaccess must point to 404.php):","type"=>"text"),
	"system_whois_url"=> array("des"=>"WHOIS lookup URL (IP appended, include your own '='):","type"=>"text"),
	array("des"=>"Submit limit options (requires sessions)","type"=>"break"),
	"system_submit_limit_enabled"=> array("des"=>"Enable the session based submit limiter:","type"=>"tf"),
	"system_submit_limit_expire"=> array("des"=>"How many minutes to keep track (worthless beyond server session expire time):","type"=>"text"),
	"system_submit_limit_value"=> array("des"=>"Number of times the form can be submitted per session:","type"=>"text"),
	"system_submit_limit_error"=> array("des"=>"Too many submissions message:","type"=>"text"),
	array("des"=>"Header options","type"=>"break"),
	"header_title"=> array("des"=>"Page title (shown in browser):","type"=>"text"),
	"header_meta"=> array("des"=>"Meta tags you want to add (for Google Webmaster Tools, etc):","type"=>"text"),
	array("des"=>"Page messages","type"=>"break"),
	"page_title"=> array("des"=>"Major heading:","type"=>"text"),
	"page_subtitle"=> array("des"=>"Sub-heading:","type"=>"text"),
	array("des"=>"Status area messages","type"=>"break"),
	"form_status_welcome"=> array("des"=>"Welcome message:","type"=>"text"),
	"form_status_success"=> array("des"=>"Send success message:","type"=>"text"),
	"form_status_error_validate"=> array("des"=>"Address validation error msg:","type"=>"text"),
	"form_status_error_MXvalidate"=> array("des"=>"MX record validation error msg:","type"=>"text"),
	"form_status_error_send"=> array("des"=>"Send server error msg:","type"=>"text"),
	array("des"=>"Form labels","type"=>"break"),
	"form_name_label"=> array("des"=>"Name field label:","type"=>"text"),
	"form_email_label"=> array("des"=>"Email field label:","type"=>"text"),
	"form_message_label"=> array("des"=>"Message field label:","type"=>"text"),
	"form_submit_label"=> array("des"=>"Submit button label:","type"=>"text"),
	//the manual setting here allows these to be changed with the single loop, but not be viewed in the auto form builder
	array("des"=>"Theme options","type"=>"break", "manual"=>true),
	"theme_directory"=> array("des"=>"Theme directory:","type"=>"text", "manual"=>true),
);


if($admin_upload_enabled){
	$arr[]=	array("des"=>"File upload configuration","type"=>"break");
	$arr["admin_upload_path"]= array("des"=>"The path to upload files (must already exist): /","type"=>"text");
	$arr["admin_upload_maxbytes"]= array("des"=>"Maximum file size allowed (bytes):","type"=>"text");
}

if($admin_upload_enabled && isset($_POST['upload'])){

	//Сheck that we have a file
	if((!empty($_FILES["uploaded_file"])) && ($_FILES['uploaded_file']['error'] == 0)) {
	  //Check if the file is JPEG image and it's size is less than 350Kb
	  $filename = basename($_FILES['uploaded_file']['name']);
	  $ext = substr($filename, strrpos($filename, '.') + 1);
	  //if (($ext == "jpg") && ($_FILES["uploaded_file"]["type"] == "image/jpeg") && ($_FILES["uploaded_file"]["size"] < 350000)) {
	  if ($_FILES["uploaded_file"]["size"] < $admin_upload_maxbytes) {//max size....
		//Determine the path to which we want to save this file
		  $newname = dirname(__FILE__).'/'.$admin_upload_path.$filename;
		  //Check if the file with the same name is already exists on the server
		  if (!file_exists($newname)) {
			//Attempt to move the uploaded file to it's new place
			if ((move_uploaded_file($_FILES['uploaded_file']['tmp_name'],$newname))) {
			   $message.= "It's done! The file has been saved as: ".$newname.'.<br/>It is avaiable at <a href="http://'.$_SERVER['HTTP_HOST'].'/'.$admin_upload_path.$filename.'">http://'.$_SERVER['HTTP_HOST'].'/'.$admin_upload_path.$filename.'</a>.';
			} else {
			   $message.= "Error: A problem occurred during file upload!";
			}
		  } else {
			 $message.= "Error: File ".$_FILES["uploaded_file"]["name"]." already exists";
		  }
	  } else {
		 $message.= "Error: larger than limit ( ".($admin_upload_maxbytes/1000000)." MB)";
	  }
	} else {
	 	$message.= "Error: No file uploaded";
	}

}

if(isset($_POST['admin'])){
	if(md5($_POST['op'])== $admin_password){
		$config->LoadFromFile(CONFIG_FILE); //open config here so is avaiable for both password and user name changes
		if( isset($_POST['np1']) && isset($_POST['np2']) && (!empty($_POST['np1'])) && (!empty($_POST['np2'])) ){ //password change
			if($_POST['np1']==$_POST['np2']){
				//change password
				//write MD5 of np1
				$var=$config->GetVar('admin_password');
				$config->SetVar('admin_password', md5($_POST['np1']), $var[CE_VARCOMMENT]);
				$config_php = $config->Save(CONFIG_FILE); //save any changes to the config file
				$message="Password changed. ";
			}else{
				$message="New passwords didn't match.";
			}
		}
		if(isset($_POST['u'])){//user name change
			$var=$config->GetVar('admin_user');
			if( !($_POST['u']==$var[CE_VARVALUE]) ){
				//update user
				$config->SetVar('admin_user', $_POST['u'], $var[CE_VARCOMMENT]);
				$config_php = $config->Save(CONFIG_FILE); //save any changes to the config file
				$message.="Administrator login changed.";
			}
		}
	}else{
		$message="Old password wrong.";
	}
}

if(isset($_POST['mxcheck']) && isset($_POST['em'])){
	require_once('contactForm.class.php');
	$cF=new contactForm;
	$cF->initConfig(); //need to load the mail settings into the class
	if($cF->validateEmailMX($_POST['em'], $cF->system_validate_MX_WINDOZ)){
		$message='<strong>Success - email server exists for '.$_POST['em'].'.</strong>';
	}else{
		$message='<strong>Failed - could not locate email server for '.$_POST['em'].'.<br/>Check the domain for errors.<br/>If you are on a Windows server check that Windows style e-mail lookup is set to true.</strong>';
	}
}

//update the values
if(isset($_POST['submit'])){ 
	// we already have a config
	$config->LoadFromFile(CONFIG_FILE);
	foreach($arr as $key => $val){
		switch($val['type']){
			case  "break":
				break;
			case "text":
				if(isset($_POST[$key])){
					$var=$config->GetVar($key);
					$config->SetVar($key, stripslashes($_POST[$key]), $var[CE_VARCOMMENT]);
				}
				break;
			case "tf":
				if(isset($_POST[$key])){
					$var=$config->GetVar($key);
					$config->SetVar($key, stripslashes($_POST[$key]), $var[CE_VARCOMMENT],true);
				}
				break;
		}
	}
	$config_php = $config->Save(CONFIG_FILE);
	require('config.inc.php'); //reload the config file to update any changed values (only $theme_directory that I know of...)
	$message="Updated system configuration file.";
}

//create a new instace of theme class... 
//used to change values, and again at the end to pull  fresh values...
//must be done after general site config update or the theme change won't take effect
require($theme_base.$theme_directory.'theme.php');
$theme=new theme;

if(isset($_POST['theme'])){
	$tharr=$theme->get_options();
	foreach($tharr as $key => $val){
		switch($val['type']){
			case  "break":
				break;
			case "text":
				if(isset($_POST[$key])){
					$tharr[$key]['val']=stripslashes($_POST[$key]);
				}
				break;
			case "tf":
				if(isset($_POST[$key])){
					$tharr[$key]['val']=stripslashes($_POST[$key]);
				}
				break;
		}
	}
	$theme->set_options($config,$tharr);
	$message='Theme options updated.';
}

// load the config file again to get fresh values
$config->LoadFromFile(CONFIG_FILE);
//load the theme info now...
//this renews the theme options after a change...
$tharr=$theme->get_options();
$theme_id='Using theme "'.$theme->name.'" v '.$theme->version.' by '.$theme->author.'.';

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Contact form configuration</title>
</head>

<body>
<a href="?logout=logout">LOGOUT</a><br/>
<strong><font color=red><?php echo $message;?></font></strong><br/>
<strong>Admin Tools</strong><br/>
<?php if($admin_upload_enabled){?>
<form enctype="multipart/form-data" action="" method="post">
    <strong>Upload a file</strong><br/>
    Choose a file <input name="uploaded_file" type="file" />
    <input type="submit" name="upload" id="upload" value="Upload" />
</form>
<br/>
<form id="testemail" name="testemail" method="post" action="">
    <strong>Test email domain verification</strong><br/>
    Enter an email (like 'test@gmail.com')
	<input name="em" type="text" />
    <input type="submit" name="mxcheck" id="mxcheck" value="Check" />
</form><br/><br/>
<strong>System Configuration</strong><br/>
<form id="update" name="update" method="post" action="">
<?php foreach($arr as $key => &$val){

		if(isset($val['manual'])){continue;} //skip the parts that are manually placed
		
		switch($val['type']){
			case  "break":
				echo '<strong>'.htmlspecialchars($val['des']).'</strong><br/>';
				break;
			case "text":
				$var=$config->GetVar($key);?>
                <label for="<?php echo $key;?>" id="<?php echo $key;?>"><?php echo htmlspecialchars($val['des']);?></label>
                <input name="<?php echo $key;?>" type="text" value="<?php echo htmlspecialchars($var[CE_VARVALUE]);?>" size="100" />
                <br/><?php
				break;
			case "tf":
				$var=$config->GetVar($key);?>
                <label for="<?php echo $key;?>" id="<?php echo $key;?>"><?php echo htmlspecialchars($val['des']);?></label>
                  <select name="<?php echo $key;?>" id="<?php echo $key;?>">
                    <option value="true" <?php if($var[CE_VARVALUE]){?>selected="selected"<?php }?>>True</option>
                    <option value="false" <?php if(!$var[CE_VARVALUE]){?>selected="selected"<?php }?>>False</option>
                  </select>
				  <br/><?php
				break;
		}
	}?>
    <input type="submit" name="submit" id="submit" value="Submit" />
</form>
<br/>
<strong>Theme Configuration</strong><br/>
<form id="themedir" name="themedir" method="post" action="">
	<?php $var=$config->GetVar('theme_directory');?>
	<label for="theme_directory" id="theme_directory">Active theme directory: /<?php echo $theme_base;?></label>
    <input name="theme_directory" type="text" value="<?php echo htmlspecialchars($var[CE_VARVALUE]);?>" size="100" />
    <input type="submit" name="submit" id="submit" value="Change" />
</form>
<?php echo $theme_id;?><br/>
<strong>Custom theme options</strong><br/>
<form id="theme" name="theme" method="post" action="">
<?php foreach($tharr as $key => $val){

		switch($val['type']){
			case  "break":
				echo '<em>'.htmlspecialchars($val['des']).'</em><br/>';
				break;
			case "text":
				?>
                <label for="<?php echo $key;?>" id="<?php echo $key;?>"><?php echo htmlspecialchars($val['des']);?></label>
                <input name="<?php echo $key;?>" type="text" value="<?php echo htmlspecialchars($val['val']);?>" size="100" />
                <br/><?php
				break;
			case "tf":
				?>
                <label for="<?php echo $key;?>" id="<?php echo $key;?>"><?php echo htmlspecialchars($val['des']);?></label>
                  <select name="<?php echo $key;?>" id="<?php echo $key;?>">
                    <option value="true" <?php if($val['val']){?>selected="selected"<?php }?>>True</option>
                    <option value="false" <?php if(!$val['val']){?>selected="selected"<?php }?>>False</option>
                  </select>
				  <br/><?php
				break;
		}
	}?>
    <input type="submit" name="theme" id="theme" value="Submit" />
</form>
<br/>
<?php }?>
<Strong>Adminstration Settings</Strong><br/>
<strong>Change admin user and password</strong><br/>
<form id="pass" name="pass" method="post" action="">
    <label for="op" id="op">Current password</label>
    <input name="op" type="password" size="100" /><br/>
    
    <?php $var=$config->GetVar('admin_user');?>
	<label for="u" id="u">Admin user name</label>
    <input name="u" type="text" value="<?php echo htmlspecialchars($var[CE_VARVALUE]);?>" size="100" /><br/>
 
    <label for="np1" id="np1">New password</label>
    <input name="np1" type="password" size="100" /><br/>

    <label for="np2" id="np2">Verify new password</label>
    <input name="np2" type="password" size="100" /><br/>

    <input type="submit" name="admin" id="admin" value="Update" />
</form>
</body>
</html>
