/*
   PaperSynth v2
   by Bryan Cera, 2016

   Learn more at http://papersynth.bryancera.com

   This sketch is firmware for PaperSynth v2.
   It is written for the ATTINY85 micro.

   New features in this version include four
   different "modes" as well as notes contrained
   to the pentatonic scale (so everything you play
   will sound great!)

   See comments below for more information.

*/

// array of notes in pentatonic scale
int pentatonicTable[36] = {
  103, 115, 129, 154, 173, 206, 231, 259, 308, 346,
  411, 461, 518, 616, 691, 822, 923, 1036, 1232, 1383, 1644, 1845, 2071
};

//variable to store current "mode"
int mode;
//timer for button debounce
int timer;

//variables for drums
int fader;
int timerB;

void setup() {
  //declare inputs and outputs
  pinMode(0, OUTPUT);
  pinMode(2, INPUT);
  digitalWrite(2, HIGH);
}

void loop() {

  //read soft pot
  int sensorReading = analogRead(2);
  
  //check for button press
  //light up LED on press
  if (digitalRead(2) == 0) {
    timer++;
    analogWrite(0, 255);
  }
  else {
    timer = 0;
    analogWrite(0, 0);
  }

  if (timer == 1) {
    mode++;
  }

  //fuzzy math for linear soft pot
  float dampener = (sensorReading * sensorReading) / 400;
  int scaledResult = int(sensorReading - dampener);

  //contrain sensor reading
  if (scaledResult > 100) {
    scaledResult = 100;
  }
  if (scaledResult < 20) {
    scaledResult = 20;
  }

  //read potentiometer
  int knob = analogRead(3);

  //modes (trigger lead and drums functions)
  if (mode > 4) {
    mode = 0;
  }

  if (mode == 0) {
    lead(scaledResult, knob, 1);
  }
  else if (mode == 1) {
    lead(scaledResult, knob, 2);
  }
  else if (mode == 2) {
    lead(scaledResult, knob, 3);
  }
  else if (mode == 3) {
    lead(scaledResult, knob, 4);
  }
  else if (mode == 4) {
    drums(scaledResult);
  }

}















