from setuptools import setup, Extension

extension = Extension(
    'vl53l1x_python',
    define_macros=[],
    extra_compile_args=['-std=c99'],
    include_dirs=['.', 'api/core', 'api/platform'],
    libraries=[],
    library_dirs=[],
    sources=['api/core/vl53l1_api_calibration.c',
             'api/core/vl53l1_core.c',
             'api/core/vl53l1_core_support.c',
             'api/core/vl53l1_api_core.c',
             'api/core/vl53l1_api_preset_modes.c',
             'api/core/vl53l1_silicon_core.c',
             'api/core/vl53l1_register_funcs.c',
             'api/core/vl53l1_wait.c',
             'api/core/vl53l1_error_strings.c',
             'api/core/vl53l1_api_strings.c',
             'api/core/vl53l1_api.c',
             'api/platform/vl53l1_platform.c',
             'python_lib/vl53l1x_python.c'])

setup(name='VL53L1X',
      version='0.0.3',
      description='vl53l1x distance sensor driver for Raspberry Pi',
      maintainer='Phil Howard',
      maintainer_email='phil@pimoroni.com',
      url='https://github.com/pimoroni/vl53l1x-python',
      long_description=open('README.md').read() + "\n" + open('CHANGELOG.txt').read(),
      ext_modules=[extension],
      package_dir={'': 'python'},
      py_modules=['VL53L1X'],
      requires=['smbus2'],
      install_requires=['smbus2'])
