/* This demo uses the UsbJoystick.h library, a library based on AVRUSB from ObDev
 * It demonstrates a 6-axis joystick with 4 buttons by reading all the analog ports and
 * digtal pins 9,10,11,and 12
 * Adapted from the UsbKeyboard.h library from Phil Lindsay
 *
 * by Michel Gutlich   19-8-2008
 *
 * Readapted for NES control pad by Osgeld 6-26-2010
 */

#include <UsbJoystick.h>

#define NES_BUTTON_UP      5
#define NES_BUTTON_DOWN    6
#define NES_BUTTON_LEFT    7
#define NES_BUTTON_RIGHT   8
#define NES_BUTTON_SELECT  13
#define NES_BUTTON_START   12 
#define NES_BUTTON_B       11
#define NES_BUTTON_A       14



#include "WProgram.h"
void setup();
void loop ();
void calculateReport();
unsigned short a2dValue;
unsigned char high;
unsigned char low;
unsigned char temp;
unsigned char report[8];


void setup()
{
  pinMode(NES_BUTTON_UP,     INPUT);
  pinMode(NES_BUTTON_DOWN,   INPUT);
  pinMode(NES_BUTTON_LEFT,   INPUT);
  pinMode(NES_BUTTON_RIGHT,  INPUT);
  pinMode(NES_BUTTON_SELECT, INPUT);
  pinMode(NES_BUTTON_START,  INPUT);
  pinMode(NES_BUTTON_B,      INPUT);
  pinMode(NES_BUTTON_A,      INPUT);  
}

void loop () {
  UsbJoystick.refresh(); // Let the AVRUSB driver do some houskeeping
  calculateReport(); // Jump to our port read routine that orders the values
  UsbJoystick.sendJoystick(report[0],report[1],report[2],report[3],report[4],report[5],report[6],report[7]); // send the values
}

void calculateReport() 
{  //The values read from the analog ports have to be ordered in a way the HID protocol wants it; a bit confusing.

  if(!digitalRead(NES_BUTTON_LEFT)) a2dValue = 1;
  else if(!digitalRead(NES_BUTTON_RIGHT)) a2dValue = -1;
  else a2dValue = 512;

  high = a2dValue >> 8;
  low = a2dValue & 255;
  report[0] = low;
  temp = high;

  if(!digitalRead(NES_BUTTON_UP)) a2dValue = 1;
  else if(!digitalRead(NES_BUTTON_DOWN)) a2dValue = -1;
  else a2dValue = 512;

  high = a2dValue >> 6;
  low = a2dValue & 63;
  report[1] = (low << 2) + temp;
  temp = high;

  a2dValue = 512; // Z  
  high = a2dValue >> 4;
  low = a2dValue & 15;
  report[2] = (low << 4) + temp;
  temp = high;

  a2dValue = 512; //ROT X  
  high = a2dValue >> 2;
  low = a2dValue & 3;
  report[3] = (low << 6) + temp;
  temp = high;

  high = 0;
  low = 0;
  report[4] = temp;
  temp = high;

  a2dValue = 512; // ROT Y
  high = a2dValue >> 8;
  low = a2dValue & 255;
  report[5] = low + temp;
  temp = high;

  a2dValue = 512; // ROT Z
  high = a2dValue >> 6;
  low = a2dValue & 63;
  report[6] = (low << 2) + temp;
  temp = high;


  // 4 buttons , tossed around

  report[7] = (temp & 15) + (!digitalRead(NES_BUTTON_SELECT) << 4) +  (!digitalRead(NES_BUTTON_START) << 5) +  (!digitalRead(NES_BUTTON_B) << 6) +  (!digitalRead(NES_BUTTON_A) << 7);
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

