/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
   x                                                                                   x
   x     Script to control the motor speed of a televisor with an arduino              x
   x     It accompagnies the instructable 'Cardboard Televisor' on Instructables       x
   x     I don't know what the final url will be, but it can be found here:            x
   x     http://www.instructables.com/member/Sparticles/                               x
   x                                                                                   x
   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
*/




unsigned long time = 0;        //to store the time to actually calculate the delays.
unsigned long delayTime;       //a delaytime needed to compare with a new delaytime. e.g. If it is shorter, the disc has increased speed.
boolean oldconn = false;       //to see if the two wires were connected during the prefious cycle of the loop().
int spunup = 0;                // a value to know if the disc is spun up. Each time a fluctuation is measured, spunup increased till treshold is reached.
boolean increasing = true;     //to remember if the disc is increasing rotational speed = 1 or decreasing = 0
int power = 80;                //The value that is written to the analogue output.  The power control of the motor. 80 is just a guess of the good value in order to speed it up faster.


//pins uses on the arduino.
int motorPin = 6;              // pin to control the motor speed with PWM
int dig = 4;                   // digital input that detects when the disc has revolved once.


//extra
char msg = '0';                //reads when the program has started.






void setup()
{
    Serial.begin(9600);          //Serial communication is used to send and receive data form laptop
    pinMode(motorPin, OUTPUT);   // sets the pin as output
    pinMode(dig, INPUT);
    pinMode(13,OUTPUT);          //just a control light.  If led 13 is on and the motor doesn't turn something is wrong.
}



void loop()
 {
    while (Serial.available()>0)
    {
        msg = Serial.read();
    }
    
  
    if(msg == '0')
    {                                          //If the laptop sends 0, the motor is shut off.
        digitalWrite(13,LOW);
        analogWrite(motorPin,0);
    }
    else
    {
        digitalWrite(13,HIGH);
        boolean conn = digitalRead(dig);       
        if((oldconn != conn) && conn ){                       //determines if the aluminium has left the leads, so the moment that the dig goes from LOW to HIGH is the anchor point of the revolution.
          
          unsigned long newTime = micros();
          unsigned long  newDelayTime = newTime - time;  
          if((newTime - time >10000))                         // sometimes an impossibly low delay of 2 ms is measured, this filters out these measurements, Probably something wrong with the wires.
          {
            time = newTime;
            long difference = newDelayTime - 83333;           // this compares the newly measured delay with the required one for 12 revolutions per second (83333 Âµs)Âµ
            
           
            for(int i = 0; i < 4; i++){                       //serial communication to the laptop.  The newDelayTime is split up in bytes and these are sent one by one. 
                Serial.write(byte(newDelayTime>>i*8)%256);    //Apparently it isn't as easy as simply Serial.write(newDelayTime) because that doesn't work for me.
            }                                                 //
            for(int i = 0; i < 2; i++){                       //The lower is send too.
                Serial.write(byte(power>>i*8)%256);           //This communication is simply for datalogging and perhaps using the signal as an anchor point to play sounds.
            }
              
      
            if(spunup < 3 )
            {                                                       //if spunup < 3  this means that the disc is probably not spun up. 3  Anomalous values are required just to be a bit more sure
                if(increasing && (delayTime <= newDelayTime)){      //if the disc should be increasing its speed but a a new delay is lager that an old one, this means that the disc isn't accelerating.
                    spunup = spunup + 1;                            //3 are needed because there are always weird values.
                }
                if(!increasing && (delayTime >= newDelayTime)){
                    spunup = spunup + 1;
                }
            }
            else
            {
                if(difference > 0)                    // if the disc spins too slow the power must be increased
                {
                    power = power + 1;
                    spunup = 0;                       //the disc must increase its speed again, so it requires some time to spin up.
                    increasing = true;                //power is increased, so the disc is increasing rotational speed.
                }
                else if(difference < 0)
                {
                    power = power - 1;
                    spunup = 0;
                    increasing = false;
                    
                }
             
            }
            delayTime = newDelayTime;                  //just remembering the delaytime for the next loop() cycle.
    
          }
    
        }
        oldconn = conn;                                //remembering if there was connection of the disc wires or not;
        analogWrite(motorPin,(int)power);              //finally the actual signal to the MOSFET that powers the motor.

  }

}
