#include <Wire.h>
#include "RTClib.h"                 
                   
RTC_DS1307 RTC;

//  6 (hour) + 9 (min) + 9 (sec) = 26 pins needed using charlieplexing to control 144 LEDs on 3 seperate rings.

//  6 pins = used for hours
//             1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30
  int a[30] = {22,23,24,25,26,27,22,23,24,25,26,27,22,23,24,25,26,27,22,23,24,25,26,27,22,23,24,25,26,27};
  int b[30] = {27,27,27,27,27,26,26,26,26,26,25,25,25,25,25,24,24,24,24,24,23,23,23,23,23,22,22,22,22,22};
//can use up to 30 pins. so there are 6 extra positions open for use.

//  9 pins (x2) = used for both minutes and seconds(+9)
//             1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60
  int c[72] = {32,31,30,29,28,36,35,34,33,32,31,30,29,28,36,35,34,33,32,31,30,29,28,36,35,34,33,32,31,30,29,28,33,32,31,30,29,28,36,35,34,33,32,31,30,29,28,36,35,34,33,32,31,30,29,28,36,35,34,33};
  int d[72] = {33,33,33,33,33,33,33,33,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,36,36,36,36,36,36,36,36,29,29,29,29,30,30,30,30,30,30,30,30,31,31,31,31,31,31,31,31,32,32,32,32,32,32,32,32};
// can control up to 72 pins. so there are 12 extra positions open for use.

void setup()
{
  Serial.begin(57600);
    Wire.begin();
    RTC.begin();
    
  //giving the DS1307 board power (for Arduino MEGA)
  //the other bins are wired to SCL and SDA lines on the arduino (for the MEGA they are pins 20 and 21) (for the Duemilanove they are on the analog pins, check the arduino website to read more).
  pinMode(18, OUTPUT);
  digitalWrite(18, LOW);
  pinMode(19, OUTPUT);
  digitalWrite(19, HIGH);
}

void loop()
{ 
  DateTime now = RTC.now();
  
  //hour
  int timeHr = now.hour();
  int modHr = timeHr % 24; // modulo 24
  
  //resets each pin so that the pin is neither HIGH nor LOW (so LEDs dont stay on)
  pinMode(22, INPUT);
  pinMode(23, INPUT);
  pinMode(24, INPUT);
  pinMode(25, INPUT);
  pinMode(26, INPUT);
  pinMode(27, INPUT);
  
  //the next several lines grab the position of the LED from the arrays a[] and b[] (cathode and anode) and set them to HIGH and LOW outputs for this loop.
  pinMode(a[modHr], OUTPUT);
  pinMode(b[modHr], OUTPUT);
  
  digitalWrite(a[modHr],HIGH);
  digitalWrite(b[modHr],LOW);
  
  //minute
  int timeMin = now.minute();
  int modMin = timeMin % 60;
  
  pinMode(28, INPUT);
  pinMode(29, INPUT);
  pinMode(30, INPUT);
  pinMode(31, INPUT);
  pinMode(32, INPUT);
  pinMode(33, INPUT);
  pinMode(34, INPUT);
  pinMode(35, INPUT);
  pinMode(36, INPUT);
  
  pinMode(c[modMin], OUTPUT);
  pinMode(d[modMin], OUTPUT);
  
  digitalWrite(c[modMin],HIGH);
  digitalWrite(d[modMin],LOW);
  
  //second
  int timeSec = now.second();
  int modSec = timeSec % 60;
  
  pinMode(37, INPUT);
  pinMode(38, INPUT);
  pinMode(39, INPUT);
  pinMode(40, INPUT);
  pinMode(41, INPUT);
  pinMode(42, INPUT);
  pinMode(43, INPUT);
  pinMode(44, INPUT);
  pinMode(45, INPUT);
  
  pinMode((c[modSec] + 9), OUTPUT);
  pinMode((d[modSec] + 9), OUTPUT);
  
  digitalWrite((c[modSec] + 9),HIGH);
  digitalWrite((d[modSec] + 9),LOW);
  /*
  pinMode(37, OUTPUT);
  pinMode(38, OUTPUT);
  pinMode(39, OUTPUT);
  pinMode(40, OUTPUT);
  pinMode(41, OUTPUT);
  pinMode(42, OUTPUT);
  pinMode(43, OUTPUT);
  pinMode(44, OUTPUT);
  pinMode(45, OUTPUT);
  
  digitalWrite(37,LOW); //1
  digitalWrite(38,LOW); //2
  digitalWrite(39,LOW); //3
  digitalWrite(40,LOW); //4
  digitalWrite(41,LOW); //5
  digitalWrite(42,LOW);
  digitalWrite(43,LOW);
  digitalWrite(44,LOW); //8@5 off
  digitalWrite(45,HIGH);*/
}
