package matrix;

import java.util.HashMap;

public class LEDFont {
	private HashMap<Character, boolean[][]> m_charMap = new HashMap<Character, boolean[][]>();
	
	private int m_width;
	private int m_height;
	
	public LEDFont(int w, int h) {
		m_width = w;
		m_height = h;
	}
	
	public int getWidth() { return m_width; }
	public int getHeight() { return m_height; }
	
	public void addCharacter(char c, boolean[][] val) {
		if (val.length == m_height && val[0].length == m_width)
		m_charMap.put(c, val);
	}
	
	public boolean[][] getCharacter(char c) {
		if (!m_charMap.containsKey(c)) {
			return new boolean[m_height][m_width];
		}
		return m_charMap.get(c);
	}
}
