

import matplotlib.pyplot as plt
from hersheyFonts import hersheyFonts

# uncomment if you wish to use the plotting features in the routine
#from createArcs import createArcs

"""
makedots.py by John Wallin

This python script is used to layout points that can be used
to create scratch hologram.  Currently it only supports text.
To change the text and dimensions of the hologram, just edit
the variables below in the __init__ routine.

I wrote this code on a Mac, but it should run everywhere.  Currently
the output of the file - the centers of the arcs - is just sent to the terminal
output.  You can past this into a text file or use commandline redirect:

python makedots.py > mydots.txt   

You can edit the dots if you like
or alter the code for experimental use.   

Once you have the dots file, you can generate the gcode.

This program is covered by the Creative Commons License along 
with the rest of the product.

I wrote this code in Python 2 - because I am a rebel.
"""

class holofont:

  def __init__(self):
    self.hf = hersheyFonts()
    self.arc = createArcs() 

    self.s = "MTSU"  # the string being rendered
    self.figureSizeX = 6  # in inches
    self.figureSizeY = 6  # in inches
    self.figureSize = 6  # figure size in inches

    self.aspectratio = 0  # aspect ratio of the plot
    self.margin = 0.0  # margin around plot
    self.lw = 0.1  # line width for scratches
    self.findex = 10 # font index
    self.gscale = 1.0 
    self.radius = 0.0 # radius of the stylus
    
  
  def layoutDots(self):

    # setup the fonts and form the set of line segments that represents the string
    self.hf.readFontIndex(self.findex)
    aa = self. hf.formString(self.s)

    # find the limits of the segments
    [xmin, xmax, ymin, ymax, xcenter, ycenter] =self.hf.findStringLimits()

    # find the actual points for the plot - these need to be offset and rescaled
    xpts, ypts = self.hf.calcPoints( plt)

    widthAvailable  = self.figureSizeX - 2.0 * self.radius - 2.0 * self.margin
    heightAvailable = self.figureSizeY - 1.0 * self.radius - 2.0 * self.margin

    xScaleTrial = widthAvailable / (xmax-xmin) 
    yScaleTrial = heightAvailable /(ymax-ymin)
    actualScale = min(xScaleTrial, yScaleTrial)

    # assumes the initial posiiton of the scriber is on the left side
    # the actual center will be offset by self.margin + self.radius
    xoffset = self.margin
    yoffset = self.margin - self.radius

    # make an array of points
    xplt = []
    yplt = []
    for i in range(len(xpts)):
      xplt.append( (xpts[i]-xmin)*actualScale + xoffset + self.radius)
      yplt.append( -(ypts[i]-ymin)*actualScale + yoffset)


    # find y min
    ymin = 10000
    for i in range(len(xpts)):
        if yplt[i] < ymin:
            ymin = yplt[i]

   
    # adjust the final points so the hologram is near the bottom of the plastic
    for i in range(len(xpts)):
        yplt[i] = yplt[i] - ymin

    # print this out
    for i in range(len(xpts)):
        if i%1 == 0:
            s = str(xplt[i]) + ", " + str(yplt[i]) 
            print s


# this routine is used to plot thin arcs if you want to attempt making 
# scratch holograms using the laser etcher.   I have commented it out 
# since it isn't required for the final code.
"""
  def createFigure(self):
    fig = plt.figure( figsize=(self.figureSize, self.figureSize))
    fig.patch.set_facecolor('white')
    ax = fig.add_subplot(111)  #,aspect='equal')
    
    ax.get_xaxis().set_visible(False)
    ax.get_yaxis().set_visible(False)
    ax.set_frame_on(False)

    xstart = 10
    ystart = 0
    #print self.hf.fontList[self.findex]
    self.hf.readFontIndex(self.findex)
    aa = self. hf.formString(self.s)
    [xmin, xmax, ymin, ymax, xcenter, ycenter] =self.hf.findStringLimits()

    xmin = xmin - (xcenter-xmin) * self.gscale
    xmax = xmax + (xmax-xcenter) * self.gscale
    ymax = (xmax+xmin)/2.0
    ymin = -ymax
    plt.xlim(xmin, xmax)
    plt.ylim(ymin, ymax)

    self.hf.plotString( plt, xstart, ystart)
    xpts, ypts = self.hf.calcPoints( plt)

    triangle = []
    for i in range(len(xpts)):
        triangle.append( [xpts[i], ypts[i], 40])
    self.arc.closedPath( plt, triangle, self.lw, ax)
    plt.plot(xpts, ypts,"*b")
    #fig.savefig("holo.svg")
    plt.savefig("plot.jpg")
    plt.show()

  plt.close()
"""


if __name__ == "__main__":

  hh = holofont()
  hh.layoutDots() 
