// Function for setting the boost converter's output to 12V. Monitors feedback voltage and adjusts duty cycle.

// desiredFeedback sets the feedback voltage. To calculate the output voltage, use the voltage divider formula.
// desierdFeedback= Vout x Rbottom/(Rtop + Rbottom)
int desiredFeedback=500;
int boostFeedbackReading;

void boostConverter(){
  OCR0A=currentBoostOutput; // Sets the output duty cycle
  boostFeedbackReading = analogRead(voltageFbPin); // Measures the feedback voltage

  if(boostFeedbackReading > desiredFeedback && currentBoostOutput >minBoostOutput){
    currentBoostOutput--;
  }
  else if(boostFeedbackReading < desiredFeedback && currentBoostOutput <maxBoostOutput){
    currentBoostOutput++;
  }

}

