#ifndef VARIO_SETTINGS_H
#define VARIO_SETTINGS_H

/*------------------------------------------------*/
/*  	             SOFTWARE       		      */
/* 		 Adapt  casquette de golf			*/
/*	simplifi : pas de GPS ni SD card ni cran	*/
/*  		     Fvrier 2018        			*/
/*------------------------------------------------*/

/*********/
/* Beeps */
/*********/

/* The volume of the beeps, max = 10 */
#define VARIOMETER_BEEP_VOLUME 10

/* The variometer reacts like this according to vertical speed in m/s :       */
/* (near climbing beep is not enabled by default)                             */
/*                                                                            */
/* <--LOW-BEEP--|------SILENT------|--NEAR-CLIMBING-BEEP--|--CLIMBING-BEEP--> */
/*              |                  |                      |                   */
/*           SINKING         CLIMBING-SENSITIVITY      CLIMBING               */
#define VARIOMETER_SINKING_THRESHOLD -0.15
#define VARIOMETER_CLIMBING_THRESHOLD 0.15
#define VARIOMETER_NEAR_CLIMBING_SENSITIVITY 0.1

/* The near climbing alarm : signal that you enter or exit the near climbing zone */
/* The near climbing beep : beep when you are in near climbing zone               */
//#define VARIOMETER_ENABLE_NEAR_CLIMBING_ALARM
#define VARIOMETER_ENABLE_NEAR_CLIMBING_BEEP


/********************/
/* Measure behavior */
/********************/

/* Speed filtering :                                               */
/* Greater values give smoother speed. The base unit is 2 seconds  */
/* so size = 5 use the last 10 seconds to average speed.           */
#define VARIOMETER_SPEED_FILTER_SIZE 5

/*----------------------------*/
/*          HARDWARE          */
/*      Vario parameters      */
/*                            */
/*----------------------------*/

/* Comment or uncomment according to  */
/* what you embed in the variometer   */ 
#define HAVE_SPEAKER
#define HAVE_ACCELEROMETER

/* If you embed an accelerometer set the model here. */
/* Possible values are :                             */
/*   MPU6050, MPU6500, MPU9150, MPU9250              */
#define MPU9250


/* I2C speed                                   */
/* You can try 800 on <8mhz microcontrollers   */ 
/* (Not always work)                           */
#define FASTWIRE_SPEED 400

#endif
