/*  ledStripADK

    Controls an LED strip with a relay, and an Arduino ADK.  The LED strip is
    then able to be controled by any Android device.
      
    created 25 Mar 13
    made by Quin (Qtechknow)
    
    originally made by Handbag Team  
 */

#include <AndroidAccessory.h>  // include the two libraries we will be using

#include "Handbag.h"


AndroidAccessory acc("rancidbacon.com",
		     "Handbag",
		     "Handbag (Arduino Board)",
		     "0.1",
		     "http://HandbagDevices.com/#i");

HandbagApp Handbag(acc);  // initiate the library


const int ledStripPin = 7;

void turnLedOn() {  
  digitalWrite(ledStripPin, HIGH);  // turn LED strip on when button is pressed
}


void turnLedOff() {
  digitalWrite(ledStripPin, LOW); 
}

void setupUI() {

    Handbag.addLabel("");  //setup our user interface/app menu
    Handbag.addLabel("LED Lighting Test", 16, 0x01); 
    Handbag.addLabel("");  //make the labels, buttons
    Handbag.addButton("Turn LED Strip on", turnLedOn);
    Handbag.addButton("Turn LED Strip off", turnLedOff);              
    Handbag.addLabel("");
    Handbag.addLabel("Qtechknow", 32, 0x01);

}


void setup() {
  Serial.begin(9600);
  
  pinMode(ledStripPin, OUTPUT);   // declare LED strip pin as output
  
  Handbag.begin(setupUI);  //setup the app menu
}


void loop() {
  Handbag.refresh();   // refresh over, and over
}


