var
	options = require('./options'),
	express = require('express'),
	_ = require("underscore"),
    bodyParser = require('body-parser')	
    channels = {},
    timestamp = null;
	;

var app = express();
app.set('view engine', 'ejs');

app.use(bodyParser.urlencoded({
		extended: true
}));
app.use(bodyParser.json());

app.use(express.static(__dirname + '/public'));
app.use(express.static(__dirname + '/bower_components'));

var server = require('http').createServer(app);
var io = require('socket.io').listen(server);

app.get('/', function(req, res) {
	res.render('index', { 'timestamp': timestamp});
});

app.get('/timestamp', function(req, res) {
	res.status(200).json({'success':true, 'timestamp':timestamp, 'now':new Date().getTime()})
});


app.put('/timestamp/:timestamp', function(req, res) {
	if (!timestamp)
	{
		console.log(req.params);
		if (req.params && req.params.timestamp)
		{
			timestamp = parseInt(req.params.timestamp, 10);
			channels.eventChannel.emit('live', JSON.stringify({'live':true, 'timestamp':timestamp, 'now':new Date().getTime()}));
			res.status(200).json({'success':true, 'timestamp':timestamp, 'now':new Date().getTime()});
		}
	}
	else
	{
		res.status(400).json({'success':false, 'msg':'timestamp already set or no timestamp given'})	
	}	
});

app.put('/timestamp', function(req, res) {
	if (!timestamp)
	{
		timestamp = new Date().getTime();
		channels.eventChannel.emit('live', JSON.stringify({'live':true, 'timestamp':timestamp, 'now':new Date().getTime()}));
		res.status(200).json({'success':true, 'timestamp':timestamp, 'now':new Date().getTime()});
	}
	else
	{
		res.status(400).json({'success':false, 'msg':'timestamp already set.'})	
	}
	

	
});



app.delete('/timestamp', function(req, res) {
	timestamp = null;
	channels.eventChannel.emit('live', JSON.stringify({'live':false}));
	res.status(200).json({'success':true, 'live': false, 'timestamp':timestamp})
});

channels.eventChannel = io.of('/events');
channels.eventChannel.on('connection', function(socket){
  	console.log('some events socket.io client connected');
});

server.listen(options.web_port);
console.log("Web server up, listening for requests on port " + options.web_port); 