var intervalId = null, timestamp, now, speed=1000;

$( document ).ready(function() {
	console.log("Ready. Go change the world.");
	createChannel();
	checkLiveness();

});

function checkLiveness()
{
	$.ajax({
	    url : '/timestamp',
	    type : 'GET',
	    dataType: 'json',
	    contentType : 'application/json',
	    success: function(data, textStatus, jqXHR){
	      console.log(data);
	      
	      //we had a go live
	      if (data.timestamp != null)
	      {
			$('#live').removeClass('hidden');
    		$('#notlive').addClass('hidden');

    		now = data.now;
    		timestamp = data.timestamp; //go live timestamp
    		startUpdating();
	      }
	      //not yet live
	      else
	      {
	      	$('#live').addClass('hidden');
    		$('#notlive').removeClass('hidden');
	      }
	    },
	    error: function(jqXHR, textStatus,errorThrown ){
	      console.log(errorThrown);
	    }
  	});
}

// datepart:  'm', 'w', 'd', 'h', 'n', 's'
function dateDiff(datepart, fromdate, todate) {	
  datepart = datepart.toLowerCase();	
  var diff = todate - fromdate;	
  var divideBy = { w:604800000, 
                   d:86400000, 
                   h:3600000, 
                   n:60000, 
                   s:1000 };	
  
  return Math.floor( diff/divideBy[datepart]);
}


function createChannel() {
    console.log("Creating socket.io channel...");
    
    var socket = io(window.location.origin + '/events');
    //var socket = io('https://api.yaas.io/bwvdkjoen57b/moto/v1/groups');
  	
  	socket.on('live', function (data) {
    	console.log('LIVE | ' + data.toString());

    	var obj = JSON.parse(data.toString());
    	if (obj.live)
    	{
    		timestamp = obj.timestamp;
    		now = obj.now;
    		$('#live').removeClass('hidden');
    		$('#notlive').addClass('hidden');
    		updateTime(); //so old ui is cleared
    		stopUpdating();
    		startUpdating();

    	}
    	else
    	{
    		$('#live').addClass('hidden');
    		$('#notlive').removeClass('hidden');
    		stopUpdating();
    	}
  	});
}

function updateTime()
{
	now += 1000;

	var s = dateDiff('s', timestamp, now) % 60;
	var n = dateDiff('n', timestamp, now) % 60;
	var h = dateDiff('h', timestamp, now) % 24;
	var d = dateDiff('d', timestamp, now) % 7;
	var w = dateDiff('w', timestamp, now);

	$('#s').text(s);
	$('#n').text(n);
	$('#h').text(h);
	$('#d').text(d);
	$('#w').text(w);

}

function startUpdating() {
	intervalId = setInterval(updateTime, speed);	
}

function stopUpdating() {
	if (intervalId != null){
		success = clearInterval(intervalId);
		intervalId = null;
	}
}
