//Project created by Tamas Imets for Jedi Home Automation Project

var Accel = require('ui/accel');
Accel.init();
var UI = require('ui');
var ajax = require('ajax');
var Vector2 = require('vector2');

// Create Window
var main_window = new UI.Window();

// Open Button and Display
var txtOnLabel = new UI.Text({
    position: new Vector2(0, 60),
    size: new Vector2(144, 30),
    font: 'Gothic 28 Bold',
    text: 'USE THE FORCE',
    textAlign: 'center',						
    color: 'white'
});

var info = new UI.Text({
    position: new Vector2(2, 90),
    size: new Vector2(142, 60),
    font: 'Gothic 14',
    text: 'Move your hand like a Jedi to control objects, lights and your home...',
    textAlign: 'center',						
    color: 'white'
}); 

var image = new UI.Image({
  position: new Vector2(0, 8),
  size: new Vector2(144, 50),
  alignImage: 'center',
  image: 'images/negativevader.png'
});

// Display Main Window
main_window.backgroundColor('black');
main_window.add(txtOnLabel);
main_window.add(info);
main_window.add(image);
main_window.show();

// URL To Particle Cloud
function Toggle(function_name,function_value){
  var URL = 'https://api.particle.io/v1/devices/your code/' + function_name +'?access_token=your token';

  ajax(	
    {
      url: URL,
      method: 'post',	
      type: 'json',
      data: { "args": function_value}
    }
  );
}

// Accelerometer Poll and Function (Default 100Hz 25)
Accel.on('data', function(e) {
  console.log(e.accel.z);
  if (e.accel.z > 1200) {
    if(e.accel.y > 200) {
      if(e.accel.x < 400) {
  Toggle('jedi','pull');
  }}}});

Accel.on('data', function(e) {
  console.log(e.accel.x);
  if (e.accel.x > 700) {
  Toggle('jedi','push');
  }});

Accel.on('data', function(e) {
  console.log(e.accel.y);
  if (e.accel.y > 1200) {
    if(e.accel.z < -200) {
      if(e.accel.z < 100) {
  Toggle('jedi','throw');
  }}}});

// Button Function and Photon Parameters
main_window.on('click', 'up', function() {
  Toggle('jedi','pull');
});

main_window.on('click', 'select', function() {
  Toggle('jedi','push');
});

main_window.on('click', 'down', function() {
  Toggle('jedi','throw');
});
