#include "gl.h"

#ifndef PIXEL_H
#define PIXEL_H

typedef struct {
    GLenum type;
    GLint red, green, blue, alpha;
} colorlayout_t;

typedef struct {
    GLfloat r, g, b, a;
} pixel_t;

#define widthalign(width, align) ((((uintptr_t)(width))+((uintptr_t)(align)-1))&(~((uintptr_t)(align)-1)))

bool pixel_convert(const GLvoid *src, GLvoid **dst,
                   GLuint width, GLuint height,
                   GLenum src_format, GLenum src_type,
                   GLenum dst_format, GLenum dst_type, GLuint stride, GLuint align);

bool pixel_transform(const GLvoid *src, GLvoid **dst,
                   GLuint width, GLuint height,
                   GLenum src_format, GLenum src_type,
                   const GLfloat *scale, const GLfloat *bias);

bool pixel_scale(const GLvoid *src, GLvoid **dst,
                  GLuint width, GLuint height,
                  GLfloat ratio,
                  GLenum format, GLenum type);

bool pixel_halfscale(const GLvoid *src, GLvoid **dst,
                  GLuint width, GLuint height,
                  GLenum format, GLenum type);

bool pixel_thirdscale(const GLvoid *src, GLvoid **dst,
                  GLuint width, GLuint height,
                  GLenum format, GLenum type);

bool pixel_quarterscale(const GLvoid *src, GLvoid **dst,
                  GLuint width, GLuint height,
                  GLenum format, GLenum type);

bool pixel_doublescale(const GLvoid *src, GLvoid **dst,
                  GLuint width, GLuint height,
                  GLenum format, GLenum type);

bool pixel_to_ppm(const GLvoid *pixels,
                  GLuint width, GLuint height,
                  GLenum format, GLenum type, GLuint name, GLuint align);

#endif
