// Arduino Uno with Ethernet Shield Web control PC165DNR Camera OSD
// 2013 Kevin Palivec
#include <SPI.h>
#include <Ethernet.h>

byte mac[] = { 0x0A, 0xA3, 0xDB, 0x00, 0xE1, 0x)4 }; // you'll need to change this to the mac of your eth shield
byte ip[] = { 192, 168, 1, 7 }; // change this to whatever ip address you'd like your server to be on
byte gateway[] = { 192, 168, 1, 1 }; // gateway
byte subnet[] = { 255, 255, 255, 0 }; //subnet mask
EthernetServer server(80); //server port

String camString; 
String message = "";
int enterpin = 5; //these are the pins that control each button on the camera
int rightpin = 8;
int leftpin = 9;
int uppin = 6;
int downpin = 7;

void setup(){

  Serial.begin(9600);
  //first lets set all the pins to low so nothing crazy happens!
  for (int i=5; i<9; i++){ 
  pinMode(i, OUTPUT);
  digitalWrite (i,LOW);
  }
  //start Ethernet
  Ethernet.begin(mac, ip, gateway, gateway, subnet);
  server.begin();

  //enable serial data print 
  Serial.begin(9600); 
  }

void loop(){
  // Create a client connection
  EthernetClient client = server.available();
  if (client) {
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();

        //read char by char HTTP request
        if (camString.length() < 100) {

          //store characters to string 
          camString += c; 
          Serial.print(c);
        } 

        //if HTTP request has ended
        if (c == '\n') {

       // heres where we build the web page that is displayed
          client.println("HTTP/1.1 200 OK"); 
          client.println("Content-Type: text/html");
          client.println();
      //standard html header
      
      //startt of actual html portion of the page
          client.println("<HTML>");
          client.println("<HEAD>");
          client.println("<TITLE>Arduino GET test page</TITLE>");
          client.println("</HEAD>");
          client.println("<BODY>");

          client.println("<H1>Lets control the SuperCircuits PC164dnr via the web!</H1>");
          client.println("<table>");
          client.println("<tr>");
          client.println("<td></td><td><input type=button value=UP onmousedown=location.href='/?up;'></td><td></td></tr>");
          client.println("<tr><td><input type=button value=LEFT onmousedown=location.href='/?left;'></td><td><input type=button value=ENTER onmousedown=location.href='/?enter;'></td><td><input type=button value=RIGHT onmousedown=location.href='/?right;'></td></tr>");
          client.println("<tr><td></td><td><input type=button value=DOWN onmousedown=location.href='/?down;'></td><td></td></tr>");
          client.println("</table><br>");
          
          client.println("</BODY>");
          client.println("</HTML>");
 
          delay(1);
          //stopping client
          client.stop();

          //here we start watching for which button is pressed on the web page and tell the arduino what to do
          if (camString.substring(6,11) == "enter") //if the enter key is pressed
          {
            enter(); //jump down and activate the appropriate pin
          }
          if(camString.substring(6,10) == "down") //same here
          {
            down();
          }
          
          if(camString.substring(6,8) == "up")camString //and here
          {
            up();
          }
           
           if(camString.substring(6,10) == "left") //ditto
          {
            left();
          }  
          
          if(camString.substring(6,11) == "right") //you get the idea!
          {
            right();
          }
          //here we clear the last command so it wont keep redoing the last button pressed
          camString="";

        }
      }
    }
  }
} 
  void enter()  //when the enter button is pressed this sets the right pin to high and triggers the transistor to 
                //to short the enter signal to ground and the camera reacts accordingly
  {
    digitalWrite(enterpin, HIGH );
    Serial.println("enter");
    delay(50);
    digitalWrite(enterpin, LOW );
  }
  
 void right()  //same as above but for the right button
  {
    digitalWrite(rightpin, HIGH );
    Serial.println("right");
    delay(50);
    digitalWrite(rightpin, LOW );

  }
 
 void left()   //and so forth
  {
    digitalWrite(leftpin, HIGH );
    Serial.println("left");
    delay(50);
    digitalWrite(leftpin, LOW );

  }

 void up()
  {
    digitalWrite(uppin, HIGH );
    Serial.println("up");
    delay(50);
    digitalWrite(uppin, LOW );

  }
 
 void down()
  {
    digitalWrite(downpin, HIGH );
    Serial.println("down");
    delay(50);
    digitalWrite(downpin, LOW );
 
  }















