/*
This sketch will let you adjust and find the home (starting) positions for the
4 servos on the icbob bi-ped robot. When satisfied record these numbers for use
in other sketches.

Written by The Bridgeville Delaware Public Library Teen Imagineering Club
This code is in the public domain
*/
#include <VarSpeedServo.h>  //include the VarSpeedServo library

VarSpeedServo RH;  //create 4 VarSpeedServo objects for the 4 servos
VarSpeedServo RA;
VarSpeedServo LH;
VarSpeedServo LA;

int svsp = 10;  //speed setting for VarSpeedServo SlowMove

//.............................................................
// Start with the 4 hm array memmbers set to 90 deg. then adjust
// these setting so the knees are straight forward and the feet are flat
int hm[4] = {95,95,85,90};  //array to hold home position for each servo RH,RA,LH,LA
//.............................................................
void setup()  //setup runs one time
{
  RH.attach(9);  //attach the 4 servo objects to the corresponding pins
  RA.attach(10);
  LH.attach(11);
  LA.attach(12);
  
  RH.slowmove (hm[0] , svsp);  //move the 4 servos to home position
  RA.slowmove (hm[1] , svsp);
  LH.slowmove (hm[2] , svsp);
  LA.slowmove (hm[3] , svsp);

}

void loop()  //loop repeats forever
{ 
  //nothing here
}
