//*****************************************
// Microdot V1
// Copyright 2006 Philip Pulle
//                RGB Sunset Productions
// For private use only, not for commercial
// use. 
// ****************************************
#include <system.h>
#include "t1rtc.h"
#include "display.h"

unsigned char nRTCSecs;
unsigned char nRTCMins;
unsigned char nRTCHours;
unsigned char nRTCTick=0;

//Start the T1 interrupt and set the time to 12:00
void init_rtc(void)
{
	asm
	{
		movlw	0x80		; preload TMR1 register pair
		movwf	_tmr1h		; for 1 secon overflow
		clrf	_tmr1l
		movlw	0x0f		; configure tmr1 for external oscillator
		movwf	_t1con		; asynchronous operation and external oscillator
		clrf	_nRTCSecs	
		clrf	_nRTCMins
		movlw	12
		movwf	_nRTCHours
		bsf		_pie1, TMR1IE	;enable interrupt
		bsf		_intcon, PEIE
		bsf		_intcon, GIE
	}
}

//FUNCTION to set the RTC timer variable or return a true/false based if the timer has reached zero
//Inputs:
//	nReset := 0=check the tick variable, >0 to set the tick variable to the specified number of seconds
//RETURNS:
//	FALSE if the tick variable is >0, TRUE if the tick variable==0
unsigned char RTCTick(unsigned char nReset)
{
	unsigned char nRet;
	nRet = (nRTCTick==0) ;
	if (nReset>0)
	{
		nRTCTick=nReset;
		nRet = 0;
	}
	return nRet;
}

//Main interrupt routine
//Most code taken from the Microchip 16F88 datasheet example
void interrupt(void)
{
	asm
	{
		btfsc	_intcon, TMR0IF	;see if RTC interrupt
		goto	int_display		;no so update display
	int_rtc:
		bsf		_tmr1h,7		;set for 1 second overflow
		bcf		_pir1,TMR1IF	;clear interrupt flag
		incf	_nRTCSecs,F		;increment seconds
		movf	_nRTCSecs,W
		sublw	60				;
		btfss	_status,Z		;60 seconds elapsed??
		goto	rtc_exit
		clrf	_nRTCSecs		;yes, so clear seconds
		clrf	_nRTCTick
		incf	_nRTCMins,F
		movf	_nRTCMins,W
		sublw	60				;60 minutes elapsed??
		btfss	_status,Z
		goto	rtc_exit		;no so return
		clrf	_nRTCMins
		incf	_nRTCHours,F	;increment hours
		movf	_nRTCHours,W
		sublw	24				;24 hours elapsed??
		btfss	_status,Z
		goto	rtc_exit
		clrf	_nRTCHours
	rtc_exit:
		movf	_nRTCTick,W		;if the tick variable is >0, then decrement otherwise leave it alone
		btfss	_status,Z
		decf	_nRTCTick,F
		goto	int_exit
	int_display:
		bcf		_intcon, TMR0IF
		call 	update_display
		bsf		_tmr0,7
	int_exit:
	}
}