//*****************************************
// Microdot V1
// Copyright 2006 Philip Pulle
//                RGB Sunset Productions
// For private use only, not for commercial
// use. 
// ****************************************
#include <system.h>
#include "control.h"
#include "display.h"
extern unsigned char nG4,nG3,nG2,nG1;
extern unsigned char nRTCSecs;
extern unsigned char nRTCMins;
extern unsigned char nRTCHours;
unsigned char nCurLed=0;

//FUNCTION to manually set the time
//INPUTS:
//	current nG4..nG1 values
//MODIFIES:
//	nG4..nG1
//OPERATION:
//	SW1 exits the time set mode
//  SW2 selects next group, upon selection the group is flashed
//  SW3 increments the number of LEDs in each group
void set_time(void)
{
	unsigned char n;
	n = 0;
	flash_group(n);
	show_time(DISP_RANDOM);
	delay_ms(25);
	while(test_bit(SW_PORT,SW1_PIN))
	{
		if(!test_bit(SW_PORT,SW2_PIN))
		{
			n++;
			if(n==4)n=0;
			flash_group(n);
			show_time(DISP_RANDOM);
			delay_ms(25);
		}
		if(!test_bit(SW_PORT,SW3_PIN))
		{
			switch(n)
			{
				case 0:
					nG4++;
					if(nG4==6)nG4=0;

					break;
				case 1:
					nG3++;
					if(nG3==10)nG3=0;
					break;
				case 2:
					nG2++;
					if(nG2==6)nG2=0;
					break;
				case 3:
					nG1++;
					if(nG1==10)nG1=0;
					break;
			}
			show_time(DISP_RANDOM);
			delay_ms(25);
		}
	}

}

//FUNCTION to scan the switches to see if user wants to set the time, or do a function
//after time is set the RTC is updated
//OPERATION:
// simultaneously pressing SW2/SW3 enters time set mode
// pressing SW1 enters function mode
// In function mode, SW2 moves to next function, SW3 activates function
void scan_switches(void)
{
	unsigned char n; 
	unsigned char i;
	
	i = 0;
	n = SW_PORT & SW_NOPRESS;	//see if any keys are pressed
	if (n==SW_NOPRESS) 
		return;	//nope, so do nothing
	set_notransition();
	if (!test_bit(SW_PORT, SW1_PIN))
	{	
		//go into set mode
		calc_time();			//get RTC into nG4..nG3
		flash_display();
		show_time(DISP_RANDOM);	//flash to show in time set mode
		flash_display();
		show_time(DISP_RANDOM);
		flash_group(n);
		n = 0;
		delay_ms(40);
		show_time(DISP_RANDOM);
		
		set_time();				//set the time
		
		//Update RTC variables with new time
		if (nG4>2) nG4 = 2;
		nRTCHours = nG4 * 10 + nG3;
		nRTCMins = nG2 * 10 + nG1;
		nRTCSecs = 0;			//on time set, set seconds to zero
		
		//flash display to show set mode over
		flash_display();
		delay_ms(20);
		flash_display();
		delay_ms(20);
		flash_display();
		show_time(DISP_RANDOM);
		delay_ms(20);
	}
	
	//perform a transition
	set_transition();
	return;
}