

;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;                                                                   |
;                  Clock using PIC12F510 and 32.768 KHz Crystal     |
;                        with spectrum analyser readout             |
;                                                                   |
;vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

;                            | 4.5 V battery
;                   +--------|[]------------+
;                   |      + |  -           |
;                   |          ___ ___      |
;       32768 Hz    +---------|   V   |-----+
;         |  |      |         |       |       1M
;   +-----|[]|----+-----------|  PIC  |-----\/\/\/\---> out
;   |     |  |    | |         |  12F  |
;   +-------------------------|  510  |----
;   |             | |         |       |
;   | 15pf   15pf | |      +--|_______|----
;   |  ||     ||  | |      |
;   +--||--+--||--+ |      |
;      ||  |  ||    |      +---------+
;          |        |       10K      |
;          +--------+-----\/\/\/\----+



 list       p=12F510
 #include   <p12F510.inc>

 __CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF & _LP_OSC & _IOSCFS_OFF

;************************** Define Constants
OPT_VAL     equ 0xd7	; timer source = instr ck / 256
COMP_DIS    equ 0xf7    ; disable comparator
ADC_DIS     equ 0       ; disable ADC module
;************************** Define Variables
 cblock 0x0a
char
col
col_ptr
row
temp
flags
count
hrs
min
sec
buff:8
 endc
;************************** Program code starts here
 org 0
 goto main

 #include chargen.inc

;************************** Subroutines
;===============================================================
; Increment seconds
;---------------------------------------------------------------
count_sec
 movlw      sec         ;address of seconds counter
 movwf      FSR         ;into file select register
 call       Mod60       ;increment it
 btfss      STATUS,Z    ;skip if zero
 retlw  0               ;if the zero flag is set then
 bsf        flags,1     ;notify that a minute has passed
;---------------------------------------------------------------
; Increment minutes
;---------------------------------------------------------------
 decf       FSR,F       ;point to minutes
 call       Mod60       ;increment minutes
 btfss      STATUS,Z    ;skip if zero
 retlw  0               ;return if nonzero
;---------------------------------------------------------------
; increment hours
;---------------------------------------------------------------
 decf       FSR,F       ;point to hours
;goto       Mod24       ;a goto is worth a call-return pair
;---------------------------------------------------------------
; increment seconds or minutes modulo 60 and hours modulo 24
;---------------------------------------------------------------
Mod24
 movlw  0x23
 goto   test_if_carry
Mod60
 movlw  0x59
test_if_carry
 xorwf  INDF,W
 btfsc  STATUS,Z
 goto   carry
 movlw  0xfa
 movwf  temp        ; minus six in temp
 movlw  0x07
 addwf  INDF,W      ; try adding 7
 btfss  STATUS,DC   ; digit carry?
 addwf  temp,w      ; no, take away six: 256 - 6 = 0xfa
 movwf  INDF        ; store
 retlw  0           ; and return - zero flag is clear
carry
 clrf   INDF        ; clear the counter
 retlw  0           ; and return - zero flag is set
;---------------------------------------------------------------
;    Unpack the BCD coded time to one digit 
;   per byte and store in display buffer area 
;---------------------------------------------------------------
format
 movlw  buff-1
 movwf  FSR
 movf   hrs,w
 call   unpack
 movwf  INDF            ;colon between hours and minutes
 movf   min,w
 call   unpack
 movwf  INDF            ;colon between minutes and seconds
 movf   sec,w
;---------------------------------------------------------------
; unpack two BCD digits and store in display area
;---------------------------------------------------------------
unpack
 incf   FSR,F
 movwf  temp
 swapf  temp,w
 andlw  0x0f
;++++++++++++++; iorlw 0x30 will give you the ASCII code
 movwf  INDF
 incf   FSR,F
 movf   temp,w
 andlw  0x0f
 movwf  INDF
 incf   FSR,F
 retlw  0x0a
;---------------------------------------------------------------
; display the time
;---------------------------------------------------------------
display
 movlw  -8
 movwf  char
char_loop
 movlw  5
 movwf  col
 movlw  buff + 8
 addwf  char,w
 bcf    STATUS,C    ; clear carry flag
 movwf  FSR
 movfw  INDF        ; get next char to be displayed
 movwf  temp        ; temp is char
 rlf    temp,f      ; W = char * 2
 rlf    temp,w      ; W = char * 4
 addwf  INDF,W      ; W = char * 5
 movwf  col_ptr     ; column pointer is char * 5
col_loop
 movfw  col_ptr
 call   Chargen
 movwf  temp
;---------------------------------------------------------------
;   First dot - 8 cycles with delay 14 instructions
 movlw  0x08
 movwf  row
row1
 btfsc  temp,6      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row1        ; 2     total 14
;---------------------------------------------------------------
;   Second dot - 8 cycles with  13 instructions loop delay
 movlw  0x08
 movwf  row
row2
 btfsc  temp,5      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row2        ; 2     total 13
;---------------------------------------------------------------
;   Third dot - 9 cycles with 12 instructions delay
 movlw  0x09
 movwf  row
row3
 btfsc  temp,4      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row3        ; 2     total 12
;---------------------------------------------------------------
;   Fourth dot - 10 cycles with 11 instructions delay
 movlw  0x0a
 movwf  row
row4
 btfsc  temp,3      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row4        ; 2     total 11
;---------------------------------------------------------------
;   Fifth dot - 11 cycles with 10 instruction delay
 movlw  0x0b
 movwf  row
row5
 btfsc  temp,2      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row5        ; 2     total 10
;---------------------------------------------------------------
;   Sixth dot - 12 cycles with 9 instruction delay
 movlw  0x0c
 movwf  row
row6
 btfsc  temp,1      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row6        ; 2     total 9
;---------------------------------------------------------------
;   Seventh dot - 14 cycles with 8 instruction delay
 movlw  0x0e
 movwf  row
row7
 btfsc  temp,0      ; 2
 bsf    GPIO,0
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row7        ; 2     total 8
;---------------------------------------------------------------
 incf   col_ptr,f
 decf   col,f
 btfss  STATUS,Z
 goto   col_loop
;---------------------------------------------------------------
;   Adjust this value for inter-digit spacing
 movlw  0x02
 movwf  row
row8
 decf   temp,f
 goto   $+1
 btfss  STATUS,Z
 goto   row8
 decf   row,f
 btfss  STATUS,Z
 goto   row8
;---------------------------------------------------------------
 incf   char,f
 btfss  STATUS,Z
 goto   char_loop
;---------------------------------------------------------------
 call   count_sec
 call   count_sec
 call   count_sec
 call   count_sec
 call   count_sec
 call   count_sec
 call   count_sec
 retlw  0 
;---------------------------------------------------------------
; Main program continues
;===============================================================
main
 movlw  COMP_DIS
 movwf  CM1CON0     ; initialise comparator module
 movlw  ADC_DIS
 movwf  ADCON0      ; initialise ADC module
 movlw  OPT_VAL
 option             ; assign timer and prescaler
 clrw
 tris   GPIO        ; make all outputs
;---------------------------------------------------------------
; initialise memory registers to sane values
 movlw  0x12
 movwf  hrs
 movlw  0x34
 movwf  min
 clrf   sec
;---------------------------------------------------------------
low_loop            ; first half of the main timing loop
 btfss  TMR0,4      ; check bit of timer register
 goto   low_loop    ; do nothing until high
high_loop           ; start of the second half
 btfsc  TMR0,4      ; check bit of timer register
 goto   high_loop   ; do nothing until low
 call   count_sec   ; then increment seconds
 movfw  sec
 andlw  0x0f
 btfss  STATUS,Z
 goto   low_loop    ; wait for the tenth second
refresh
 call   format
 call   display     ; and display the time
 goto   low_loop
;---------------------------------------------------------------
 end    ; End of program
;===============================================================

