
;====================================================================
;       ,-~~-.___.
;      / |  '     \         It  was   a   dark  and  stormy night....          
;     (  )         0              
;      \_/-, ,----'            
;         ====           //                     
;        /  \-'~;    /~~~(O)
;       /  __/~|   /       |     
;     =(  _____| (_________|   W<
;====================================================================
;
; 
;
;                            | 4.5 V battery
;                   +--------|[]------------+
;                   |      + |  -           |
;                   |          ___ ___      |
;       32768 Hz    +---------|   V   |-----+
;         |  |      |         |       |       1M
;   +-----|[]|----+-----------|  PIC  |-----\/\/\/\---> out
;   |     |  |    | |         |  12F  |
;   +-------------------------|  510  |----
;   |             | |         |       |
;   | 15pf   15pf | |      +--|_______|----
;   |  ||     ||  | |      |
;   +--||--+--||--+ |      |
;      ||  |  ||    |      +---------+
;          |        |       10K      |
;          +--------+-----\/\/\/\----+



 list       p=12F510
 #include   <p12F510.inc>

 __CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF & _LP_OSC & _IOSCFS_OFF

;************************** Define Constants
OPT_VAL     equ 0xd7	; timer source = instr ck / 256
COMP_DIS    equ 0xf7    ; disable comparator
ADC_DIS     equ 0       ; disable ADC module
;************************** Define Variables
 cblock 0x0a
flags
count1
count2
note
COUNTER
 endc
;--------------------------------------------------------------------
; flag bit definitions
rest    equ 0
tmrh    equ 1
;--------------------------------------------------------------------
; Program code starts here
 org 0
 goto    continue    ; program code is placed after table entries
;--------------------------------------------------------------------
table
 addwf  PCL,F
;--------------------------------------------------------------------
 dt 14,13,17,16,15,12,11,17,10,1c,1b,1a,19,18,0f,1d,18,0e,0a
 dt 1d,18,13,0d,0a,1c,1b,1a,19,18,13,0d,0a,18,13,0c,0b,0a,9,8,7
 dt 18,7,13,12,0a,7,1d,1c,1b,7,1a,19,18,13,10,9,7,1e,18,13,9,7,1e,18,13
 dt 10,9,7,1d,1c,7,1b,1a,19,18,13,7,18,8,7,18,0c,0b,0a,9,18,0e,0d,0a,18,17,16
 dt 10,0f,0a,15,12,11,0a,15,14,13,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
 dt 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
;--------------------------------------------------------------------
; Program code continues here
continue
 movlw  COMP_DIS
 movwf  CM1CON0     ; initialise comparator module
 movlw  ADC_DIS
 movwf  ADCON0      ; initialise ADC module
 movlw  OPT_VAL
 option             ; assign timer and prescaler
 clrw
 tris   GPIO        ; make all outputs
start
 movlw  2
 movwf  GPIO    ;GP0 high, GP2 and GP3 low
 movlw  0       ;all pins output
 tris   GPIO
 clrf   count1  ;clear note count
 clrf   flags   ;clear flags register
;--------------------------------------------------------------------
; initialisation over, endless loop starts here
forever
 movf   count1,W
 call   table
 iorlw  0
 skpnz
 goto   start   ; if note value zero start all over again
 movwf  note
 bcf    flags,rest
 decfsz note,w
 bsf    flags,rest  ; if note value = 1 set pause flag
 goto   first
third
 bcf    flags,tmrh  ; clear copy of timer high flag
 incf   count1,F    ; increment note count
 goto   forever     ; and get next note
;--------------------------------------------------------------------
; during note duration repeatedly delay and toggle pins
first
 btfss  TMR0,2      ; test bit of timer
 goto   timerhi     ; jump if high
 btfss  flags,tmrh  ; timer bit is low, so test flag
 goto   second      ; if flag is also low do nothing
 goto   third       ; they don't match, so next interval.
timerhi
 bsf    flags,tmrh
second
 btfsc  flags,rest  ; if a rest is wanted don't call Beep
 call   Beep
 goto   first 
;--------------------------------------------------------------------
Beep                ; toggle GPIO pins and delay
 movf   note,w
 movwf  COUNTER
 movlw  6           ; mask for GP0 and GP1
 xorwf  GPIO,F      ; toggle GP0 and GP1
;--------------------------------------------------------------------
;  The delay routine below is from Don Lancaster, www.tinaja.com
;--------------------------------------------------------------------
        ; Code module to provide a time delay of n instruction
        ; cycles. n can vary from 4 to 255 and is destructively
        ; read from COUNTER. There are 8 or 9 overhead cycles.
        ; The module is easily extended to 9 or 10 bits.
DELAY
 BCF    STATUS,C    ; clear carry (if needed)
 RRF    COUNTER,1   ; bit 0 into carry
 BTFSC  STATUS,C    ; stall one cycle?
 GOTO   EQ1         ; yes, one extra cycle
EQ1
 BCF    STATUS,C    ; must clear carry
 RRF    COUNTER,1   ; bit 1 into carry
 BTFSS  STATUS,C    ; stall two cycles?
 GOTO   LOOP        ; no, no extra cycles
 GOTO   EQ2         ; yes, two extra cycles
EQ2
 NOP
LOOP
 BCF    STATUS,C    ; 4*n cycle delay loop
 DECFSZ COUNTER,F
 GOTO   LOOP        ; round and round till done
 RETLW  0           ; return to calling routine
;--------------------------------------------------------------------
 end    ; end of program
;====================================================================
