

;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;                                                                   |
;       Display of an arbitrary bitmap stored as a lookup table     |
;                 with spectrum analyser readout                    |
;                                                                   |
;vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
 

;                         ____  
;                       o8%8888,    
;                     o88%8888888.  
;                    8'-    -:8888b   
;                   8'         8888  
;                  d8.-=. ,==-.:888b  
;                  >8 `~` :`~' d8888   
;                  88         ,88888   
;                  88b. `-~  ':88888  
;                  888b ~==~ .:88888 
;                  88888o--:':::8888      
;                  `88888| :::' 8888b  
;                  8888^^'       8888b  
;                 d888           ,%888b.   
;                d88%            %%%8--'-.  
;               /88:.__ ,       _%-' ---  -  
;                   '''::===..-'   =  --.  `



;                            | 4.5 V battery
;                   +--------|[]------------+
;                   |      + |  -           |
;                   |          ___ ___      |
;       32768 Hz    +---------|   V   |-----+
;         |  |      |         |       |       1M
;   +-----|[]|----+-----------|  PIC  |-----\/\/\/\---> out
;   |     |  |    | |         |  12F  |
;   +-------------------------|  510  |----
;   |             | |         |       |
;   | 15pf   15pf | |      +--|_______|----
;   |  ||     ||  | |      |
;   +--||--+--||--+ |      |
;      ||  |  ||    |      +---------+
;          |        |       10K      |
;          +--------+-----\/\/\/\----+



 list       p=12F510
 #include   <p12F510.inc>

 __CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF & _LP_OSC & _IOSCFS_OFF

;************************** Define Constants
OPT_VAL     equ 0xd7	; timer source = instr ck / 256
COMP_DIS    equ 0xf7    ; disable comparator
ADC_DIS     equ 0       ; disable ADC module
;************************** Define Variables
 cblock 0x0a
row
col
temp
 endc
;************************** Program code starts here
 org 0
 goto main

 #include instructables.inc

;************************** Subroutines
;---------------------------------------------------------------
; display the bitmap
;---------------------------------------------------------------
display
 clrf   col
col_loop
 movfw  col
 call   bitmap
 movwf  temp
 btfsc  temp,7
 retlw  0
;---------------------------------------------------------------
;   First dot - 16 cycles with delay 16 instructions
 movlw  0x10
 movwf  row
row1
 btfsc  temp,6      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row1        ; 2     total 16
;---------------------------------------------------------------
;   Second dot - 17 cycles with  15 instructions loop delay
 movlw  0x11
 movwf  row
row2
 btfsc  temp,5      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row2        ; 2     total 15
;---------------------------------------------------------------
;   Third dot - 18 cycles with 14 instructions delay
 movlw  0x12
 movwf  row
row3
 btfsc  temp,4      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row3        ; 2     total 14
;---------------------------------------------------------------
;   Fourth dot - 19 cycles with 13 instructions delay
 movlw  0x13
 movwf  row
row4
 btfsc  temp,3      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 goto   $+1         ; 2
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row4        ; 2     total 13
;---------------------------------------------------------------
;   Fifth dot - 21 cycles with 12 instruction delay
 movlw  0x15
 movwf  row
row5
 btfsc  temp,2      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row5        ; 2     total 12
;---------------------------------------------------------------
;   Sixth dot - 23 cycles with 11 instruction delay
 movlw  0x17
 movwf  row
row6
 btfsc  temp,1      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 goto   $+1         ; 2
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row6        ; 2     total 11
;---------------------------------------------------------------
;   Seventh dot - 26 cycles with 10 instruction delay
 movlw  0x1a
 movwf  row
row7
 btfsc  temp,0      ; 2
 bsf    GPIO,0
 goto   $+1         ; 2
 nop                ; 1
 bcf    GPIO,0      ; 1
 decf   row,f       ; 1
 btfss  STATUS,Z    ; 1
 goto   row7        ; 2     total 10
;---------------------------------------------------------------
 incf   col,f
 goto   col_loop
;---------------------------------------------------------------
; Main program continues
;===============================================================
main
 movlw  COMP_DIS
 movwf  CM1CON0     ; initialise comparator module
 movlw  ADC_DIS
 movwf  ADCON0      ; initialise ADC module
 movlw  OPT_VAL
 option             ; assign timer and prescaler
 clrw
 tris   GPIO        ; make all outputs
;---------------------------------------------------------------
low_loop            ; first half of the main timing loop
 btfss  TMR0,7      ; check bit of timer register
 goto   low_loop    ; do nothing until high
high_loop           ; start of the second half
 btfsc  TMR0,7      ; check bit of timer register
 goto   high_loop   ; do nothing until low
refresh
 call   display     ; and display the bitmap
 goto   low_loop
;---------------------------------------------------------------
 end    ; End of program
;===============================================================

