/*

gps_card.ino

D.R.Patterson

2/1/2015

GPS SD read card and select / read the files 
# delete filename :option

 */

// include the SD library:
#include <SPI.h>
// If using the default adafruit sd library use #include <SD.h>
#include <SDADA.h>

// set up variables using the SD utility library functions:
Sd2Card card;
SdVolume volume;
SdFile root;
File tempfile,folder;
int filecount = 0;

const int chipSelect = 32;    
const boolean debug = true;
boolean hascard=false;
char thefolder [6]  = "/gps/";
char mytypeU [5] = ".TXT";
char mytypeL [5] = ".txt";
char bufFile[30]="/gps/12345678.txt";

void setup(){
// Open serial communications and wait for port to open:
Serial.begin(115200);
// default ss must be output.
pinMode(SS, OUTPUT);
pinMode(chipSelect,OUTPUT);
hascard = checkcard();
  if(! hascard) while(1);
cardtype();
  if (!volume.init(card)) {
    Serial.println(F("Could not find FAT16/FAT32 partition.\nMake sure you've formatted the card") );
  while(1);
  }
readvolume();
  if (SD.exists(thefolder) == false) {
  Serial.println(F("Creating the folder"));
  SD.mkdir(thefolder);
  }
getdirectory();
  if(filecount == 0) {Serial.println(F("\n Nothing to do!"));while(1);}
}

void loop(void) {
getfile();
fileopen();
}

void fileopen() {
tempfile = SD.open(bufFile, FILE_READ);
  if(!tempfile) return;
Serial.println();
  while (tempfile.available()) {
  Serial.write(tempfile.read());
  }
tempfile.close();
getdirectory();
}

void getfile(){
boolean gotname=false;
char junk = ' ';
  // try to clear any stray serial input
  while (Serial.available() > 0) { junk = Serial.read() ; }
Serial.println(F("\n(Use \"#delete filename\" to delete, or \"filename\" to read)"));
Serial.println(F("\nWhich file?\n"));
byte start= sizeof(thefolder)-1;
 
  do { // wait for a valid filename from the serial input
  int charno = Serial.available();
    if ((charno > 4) && (charno < 31)) { // must be at least x.abc
    char delbuffer[30];
    Serial.readBytes(delbuffer,charno);
    delbuffer[charno]=char(0);
    String temp = delbuffer;
    // check for #delete file
    String chkdelete = temp.substring(0,7);
      if (chkdelete == "#delete"){
      temp = temp.substring(7);
      temp.trim();
        if (temp.length() == 0){
        Serial.println(F("\nKeyboard entry error"));
        goto missme;
        }  
      byte firstchar = 7;
        while(delbuffer[firstchar] == 32){
        firstchar++;
          if (firstchar == 30){
          Serial.println(F("\nKeyboard entry error"));
          goto missme;
          }
        }
        for (byte i = firstchar; i <= (charno+1); i++){
        bufFile[i - firstchar + start] = delbuffer[i];
        }
      Serial.print(F("File "));Serial.print(bufFile);
        if(SD.exists(bufFile)){
        SD.remove(bufFile);
        Serial.println(F(" deleted!"));
        getdirectory();
        Serial.println(F("\n(Use \"#delete filename\" to delete, or \"filename\" to read)"));
        Serial.println(F("\nWhich file?\n"));
        } else{
        Serial.println(F(" does not exist"));
        }
      goto missme;
      }
      // It was not #delete so check it exists and exit if it does
      if(charno>12) charno=12; // 12 characters max for a filename
      for (int j=start;j<30;j++){bufFile[j]=0;} // clear any previous filename
    strcpy(bufFile + start,delbuffer);
    bufFile[start + charno] =char(0);
      if (SD.exists(bufFile)) {
      gotname=true;
      Serial.print(F("File selected "));
      Serial.println(bufFile);
      } else {
        // try to clear any stray serial input
        while (Serial.available() > 0) { junk = Serial.read() ; } 
      Serial.print(F("No such File "));
      Serial.println(bufFile);
      Serial.println();
      }
    } else {
      if(charno >0)Serial.println(F("\nKeyboard input not clear"));
      // try to clear any stray serial input
      while (Serial.available() > 0) { junk = Serial.read() ; }  
    delay(250);
    }
  missme:;
  } while (!gotname);
}

void getdirectory(){
Serial.println();
Serial.print(F("            "));
Serial.print(thefolder);
Serial.println(F(" directory"));
folder = SD.open(thefolder);
filecount = printDirectory(folder, 0);
Serial.flush();
}

int printDirectory(File dir, int numTabs) {
String temp;
int fcount=0;

   while(true) {
   File entry =  dir.openNextFile();
     if (! entry) {
     // no more files
     Serial.println(F("*****************************************"));
     return(fcount);
     break;
     }
     for (uint8_t i=0; i<numTabs; i++) Serial.print(F("          "));
   int mylen=strlen(entry.name())-4;// compare last 4 characters
     if ((strcmp(entry.name() + mylen, mytypeU)==0) || (strcmp(entry.name() + mylen, mytypeL)==0)) {
     fcount++;
     temp = entry.name();
     temp.toLowerCase();
     Serial.print(temp);
       for(uint8_t i=mylen;i<30;i++) Serial.print(F(" "));
     Serial.println(entry.size(), HEX);
     }     
     
     if (entry.isDirectory()) {
     Serial.println(F("/"));
     printDirectory(entry, numTabs+1);
     }
   }
}

boolean checkcard(){
  Serial.print(F("\nInitializing SD card..."));
  if (!SD.begin(chipSelect, 11, 12, 13)) {
    Serial.println(F("Card init. failed!"));
    return false;
  }else{
    Serial.println(F("Card init. succeeded!"));
  }
  if (!card.init(SPI_FULL_SPEED, chipSelect, 11, 12, 13)) {
  Serial.println(F("initialization failed. Things to check:"));
  Serial.println(F("* is a card is inserted?"));
  Serial.println(F("* Is your wiring correct?"));
  Serial.println(F("* did you change the chipSelect pin to match your shield or module?"));
  return false;
  }
return true;
}

void cardtype(){
// print the type of card
Serial.print(F("\nCard type: "));
  switch(card.type()) {
    case SD_CARD_TYPE_SD1:
    Serial.println(F("SD1"));
    break;
    case SD_CARD_TYPE_SD2:
    Serial.println(F("SD2"));
    break;
    case SD_CARD_TYPE_SDHC:
    Serial.println(F("SDHC"));
    break;
    default:
    Serial.println(F("Unknown"));
  }
}

void readvolume(){
// print the type and size of the first FAT-type volume
uint32_t volumesize;
Serial.print(F("Volume type is FAT"));
Serial.println(volume.fatType(), DEC);
Serial.println();
volumesize = volume.blocksPerCluster();    // clusters are collections of blocks
volumesize *= volume.clusterCount();       // we'll have a lot of clusters
volumesize *= 512;                         // SD card blocks are always 512 bytes
Serial.print(F("Volume size (bytes): "));
Serial.println(volumesize);
Serial.print(F("Volume size (Kbytes): "));
volumesize /= 1024;
Serial.println(volumesize);
Serial.print(F("Volume size (Mbytes): "));
volumesize /= 1024;
Serial.println(volumesize);
root.openRoot(volume);
// list all files in the card with date and size
//Serial.println(F("\nFiles found on the card (name, date and size in bytes): "));
//root.ls(LS_R | LS_DATE | LS_SIZE);
}


