/*
 * Decompiled with CFR 0.152.
 */
package processing.javafx;

import java.nio.IntBuffer;
import java.util.Collection;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.core.PSurface;
import processing.javafx.PSurfaceFX;

public class PGraphicsFX2D
extends PGraphics {
    GraphicsContext context;
    static final WritablePixelFormat<IntBuffer> argbFormat = PixelFormat.getIntArgbInstance();
    Path workPath;
    Path auxPath;
    boolean openContour;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    int transformCount;
    Affine[] transformStack = new Affine[32];
    static final String MASK_WARNING = "mask() cannot be used on the main drawing surface";

    @Override
    public PSurface createSurface() {
        this.surface = new PSurfaceFX(this);
        return this.surface;
    }

    @Override
    public Object getNative() {
        return this.context;
    }

    @Override
    public void beginDraw() {
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    @Override
    public void endDraw() {
        if (!this.primaryGraphics) {
            this.loadPixels();
        }
        this.setModified();
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
        this.workPath = null;
        this.auxPath = null;
    }

    @Override
    public void texture(PImage image) {
        PGraphicsFX2D.showMethodWarning("texture");
    }

    @Override
    public void vertex(float x, float y) {
        this.curveVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][37];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
        this.vertices[this.vertexCount][0] = x;
        this.vertices[this.vertexCount][1] = y;
        ++this.vertexCount;
        switch (this.shape) {
            case 3: {
                this.point(x, y);
                break;
            }
            case 5: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 9: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 10: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], this.vertices[this.vertexCount - 1][0], this.vertices[this.vertexCount - 1][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 11: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 16: 
            case 17: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 18: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 20: {
                if (this.workPath == null) {
                    this.context.moveTo((double)x, (double)y);
                    break;
                }
                if (this.breakShape) {
                    this.context.moveTo((double)x, (double)y);
                    this.breakShape = false;
                    break;
                }
                this.context.lineTo((double)x, (double)y);
            }
        }
    }

    @Override
    public void vertex(float x, float y, float z) {
        PGraphicsFX2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float[] v) {
        this.vertex(v[0], v[1]);
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        PGraphicsFX2D.showVariationWarning("vertex(x, y, u, v)");
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        PGraphicsFX2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphics.showWarning("Already called beginContour()");
            return;
        }
        Path temp = this.auxPath;
        this.auxPath = this.workPath;
        this.workPath = temp;
        this.breakShape = true;
        this.auxPath = new Path();
        this.breakShape = true;
        this.openContour = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphics.showWarning("Need to call beginContour() first");
            return;
        }
        if (this.workPath != null) {
            this.auxPath.getElements().addAll((Collection)this.workPath.getElements());
            this.auxPath.getElements().add((Object)new ClosePath());
        }
        Path temp = this.workPath;
        this.workPath = this.auxPath;
        this.auxPath = temp;
        this.openContour = false;
    }

    @Override
    public void endShape(int mode) {
        if (this.openContour) {
            this.endContour();
            PGraphics.showWarning("Missing endContour() before endShape()");
        }
        if (this.workPath != null && this.shape == 20) {
            if (mode == 2) {
                this.workPath.getElements().add((Object)new ClosePath());
            }
            if (this.auxPath != null) {
                this.workPath.getElements().addAll((Collection)this.auxPath.getElements());
            }
        }
        this.shape = 0;
    }

    @Override
    protected void clipImpl(float x1, float y1, float x2, float y2) {
        PGraphicsFX2D.showTodoWarning("clip()", 3274);
    }

    @Override
    public void noClip() {
        PGraphicsFX2D.showTodoWarning("noClip()", 3274);
    }

    @Override
    protected void blendModeImpl() {
        BlendMode mode = BlendMode.SRC_OVER;
        switch (this.blendMode) {
            case 0: {
                PGraphicsFX2D.showWarning("blendMode(REPLACE) is not supported");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                mode = BlendMode.ADD;
                break;
            }
            case 4: {
                PGraphicsFX2D.showWarning("blendMode(SUBTRACT) is not supported");
                break;
            }
            case 8: {
                mode = BlendMode.LIGHTEN;
                break;
            }
            case 16: {
                mode = BlendMode.DARKEN;
                break;
            }
            case 32: {
                mode = BlendMode.DIFFERENCE;
                break;
            }
            case 64: {
                mode = BlendMode.EXCLUSION;
                break;
            }
            case 128: {
                mode = BlendMode.MULTIPLY;
                break;
            }
            case 256: {
                mode = BlendMode.SCREEN;
                break;
            }
            case 512: {
                mode = BlendMode.OVERLAY;
                break;
            }
            case 1024: {
                mode = BlendMode.HARD_LIGHT;
                break;
            }
            case 2048: {
                mode = BlendMode.SOFT_LIGHT;
                break;
            }
            case 4096: {
                mode = BlendMode.COLOR_DODGE;
                break;
            }
            case 8192: {
                mode = BlendMode.COLOR_BURN;
            }
        }
        this.context.setGlobalBlendMode(mode);
    }

    @Override
    public void bezierVertex(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.bezierVertexCheck();
        this.context.bezierCurveTo((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphicsFX2D.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float ctrlX, float ctrlY, float endX, float endY) {
        this.context.quadraticCurveTo((double)ctrlX, (double)ctrlY, (double)endX, (double)endY);
    }

    @Override
    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphicsFX2D.showDepthWarningXYZ("quadVertex");
    }

    @Override
    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    @Override
    protected void curveVertexSegment(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.curveCoordX[0] = x1;
        this.curveCoordY[0] = y1;
        this.curveCoordX[1] = x2;
        this.curveCoordY[1] = y2;
        this.curveCoordX[2] = x3;
        this.curveCoordY[2] = y3;
        this.curveCoordX[3] = x4;
        this.curveCoordY[3] = y4;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.workPath == null) {
            this.context.moveTo((double)this.curveDrawX[0], (double)this.curveDrawY[0]);
        }
        this.context.bezierCurveTo((double)this.curveDrawX[1], (double)this.curveDrawY[1], (double)this.curveDrawX[2], (double)this.curveDrawY[2], (double)this.curveDrawX[3], (double)this.curveDrawY[3]);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        PGraphicsFX2D.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void point(float x, float y) {
        if (this.stroke) {
            this.line(x, y, x + 1.0E-4f, y + 1.0E-4f);
        }
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        this.context.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.context.beginPath();
        this.context.moveTo((double)x1, (double)y1);
        this.context.lineTo((double)x2, (double)y2);
        this.context.lineTo((double)x3, (double)y3);
        this.context.closePath();
        if (this.fill) {
            this.context.fill();
        }
        if (this.stroke) {
            this.context.stroke();
        }
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.context.beginPath();
        this.context.moveTo((double)x1, (double)y1);
        this.context.lineTo((double)x2, (double)y2);
        this.context.lineTo((double)x3, (double)y3);
        this.context.lineTo((double)x4, (double)y4);
        this.context.closePath();
        if (this.fill) {
            this.context.fill();
        }
        if (this.stroke) {
            this.context.stroke();
        }
    }

    @Override
    protected void rectImpl(float x1, float y1, float x2, float y2) {
        if (this.fill) {
            this.context.fillRect((double)x1, (double)y1, (double)x2, (double)y2);
        }
        if (this.stroke) {
            this.context.strokeRect((double)x1, (double)y1, (double)x2, (double)y2);
        }
    }

    @Override
    protected void ellipseImpl(float x, float y, float w, float h) {
        if (this.fill) {
            this.context.fillOval((double)x, (double)y, (double)w, (double)h);
        }
        if (this.stroke) {
            this.context.strokeOval((double)x, (double)y, (double)w, (double)h);
        }
    }

    @Override
    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        start = -start * 57.295776f;
        stop = -stop * 57.295776f;
        float sweep = stop - start;
        ArcType fillMode = ArcType.ROUND;
        ArcType strokeMode = ArcType.OPEN;
        if (mode == 1) {
            fillMode = ArcType.OPEN;
        } else if (mode == 3) {
            strokeMode = ArcType.ROUND;
        } else if (mode == 2) {
            fillMode = ArcType.CHORD;
            strokeMode = ArcType.CHORD;
        }
        if (this.fill) {
            this.context.fillArc((double)x, (double)y, (double)w, (double)h, (double)PApplet.degrees(start), (double)PApplet.degrees(sweep), fillMode);
        }
        if (this.stroke) {
            this.context.strokeArc((double)x, (double)y, (double)w, (double)h, (double)PApplet.degrees(start), (double)PApplet.degrees(sweep), strokeMode);
        }
    }

    @Override
    public void box(float w, float h, float d) {
        PGraphicsFX2D.showMethodWarning("box");
    }

    @Override
    public void sphere(float r) {
        PGraphicsFX2D.showMethodWarning("sphere");
    }

    @Override
    public void bezierDetail(int detail) {
    }

    @Override
    public void curveDetail(int detail) {
    }

    @Override
    protected void imageImpl(PImage who, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (who.width <= 0 || who.height <= 0) {
            return;
        }
        ImageCache cash = (ImageCache)this.getCache(who);
        if (cash != null && ((double)who.width != cash.image.getWidth() || (double)who.height != cash.image.getHeight())) {
            cash = null;
        }
        if (cash == null) {
            cash = new ImageCache();
            this.setCache(who, cash);
            who.updatePixels();
            who.setModified();
        }
        if (this.tint && !cash.tinted || this.tint && cash.tintedColor != this.tintColor || !this.tint && cash.tinted) {
            who.updatePixels();
        }
        if (who.isModified()) {
            if (who.pixels == null) {
                who.pixels = new int[who.width * who.height];
            }
            cash.update(who, this.tint, this.tintColor);
            who.setModified(false);
        }
        this.context.drawImage((Image)((ImageCache)this.getCache((PImage)who)).image, (double)u1, (double)v1, (double)(u2 - u1), (double)(v2 - v1), (double)x1, (double)y1, (double)(x2 - x1), (double)(y2 - y1));
    }

    @Override
    public PShape loadShape(String filename) {
        return this.loadShape(filename, null);
    }

    @Override
    public PShape loadShape(String filename, String options) {
        String extension = PApplet.getExtension(filename);
        if (extension.equals("svg") || extension.equals("svgz")) {
            return new PShapeSVG(this.parent.loadXML(filename));
        }
        PGraphics.showWarning("Unsupported format: " + filename);
        return null;
    }

    @Override
    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.context.getTransform(this.transformStack[this.transformCount]);
        ++this.transformCount;
    }

    @Override
    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a pushMatrix() to go with that popMatrix()");
        }
        --this.transformCount;
        this.context.setTransform(this.transformStack[this.transformCount]);
    }

    @Override
    public void translate(float tx, float ty) {
        this.context.translate((double)tx, (double)ty);
    }

    @Override
    public void rotate(float angle) {
        this.context.rotate((double)PApplet.radians(angle));
    }

    @Override
    public void rotateX(float angle) {
        PGraphicsFX2D.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float angle) {
        PGraphicsFX2D.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float angle) {
        PGraphicsFX2D.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphicsFX2D.showVariationWarning("rotate");
    }

    @Override
    public void scale(float s) {
        this.context.scale((double)s, (double)s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.context.scale((double)sx, (double)sy);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        PGraphicsFX2D.showDepthWarningXYZ("scale");
    }

    @Override
    public void shearX(float angle) {
        Affine temp = new Affine();
        temp.appendShear(Math.tan(angle), 0.0);
        this.context.transform(temp);
    }

    @Override
    public void shearY(float angle) {
        Affine temp = new Affine();
        temp.appendShear(0.0, Math.tan(angle));
        this.context.transform(temp);
    }

    @Override
    public void resetMatrix() {
        this.context.setTransform(new Affine());
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.context.transform((double)n00, (double)n10, (double)n01, (double)n11, (double)n02, (double)n12);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphicsFX2D.showVariationWarning("applyMatrix");
    }

    @Override
    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    @Override
    public PMatrix2D getMatrix(PMatrix2D target) {
        if (target == null) {
            target = new PMatrix2D();
        }
        Affine t = this.context.getTransform();
        target.set((float)t.getMxx(), (float)t.getMxy(), (float)t.getTx(), (float)t.getMyx(), (float)t.getMyy(), (float)t.getTy());
        return target;
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphicsFX2D.showVariationWarning("getMatrix");
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.context.setTransform((double)source.m00, (double)source.m10, (double)source.m01, (double)source.m11, (double)source.m02, (double)source.m12);
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        PGraphicsFX2D.showVariationWarning("setMatrix");
    }

    @Override
    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    @Override
    public float screenX(float x, float y) {
        return (float)this.context.getTransform().transform((double)x, (double)y).getX();
    }

    @Override
    public float screenY(float x, float y) {
        return (float)this.context.getTransform().transform((double)x, (double)y).getY();
    }

    @Override
    public float screenX(float x, float y, float z) {
        PGraphicsFX2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    @Override
    public float screenY(float x, float y, float z) {
        PGraphicsFX2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    @Override
    public float screenZ(float x, float y, float z) {
        PGraphicsFX2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    @Override
    public void strokeCap(int cap) {
        super.strokeCap(cap);
        if (this.strokeCap == 2) {
            this.context.setLineCap(StrokeLineCap.ROUND);
        } else if (this.strokeCap == 4) {
            this.context.setLineCap(StrokeLineCap.SQUARE);
        } else {
            this.context.setLineCap(StrokeLineCap.BUTT);
        }
    }

    @Override
    public void strokeJoin(int join) {
        super.strokeJoin(join);
        if (this.strokeJoin == 8) {
            this.context.setLineJoin(StrokeLineJoin.MITER);
        } else if (this.strokeJoin == 2) {
            this.context.setLineJoin(StrokeLineJoin.ROUND);
        } else {
            this.context.setLineJoin(StrokeLineJoin.BEVEL);
        }
    }

    @Override
    public void strokeWeight(float weight) {
        super.strokeWeight(weight);
        this.context.setLineWidth((double)weight);
    }

    @Override
    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.context.setStroke((Paint)new Color((double)this.strokeR, (double)this.strokeG, (double)this.strokeB, (double)this.strokeA));
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        this.context.setFill((Paint)new Color((double)this.fillR, (double)this.fillG, (double)this.fillB, (double)this.fillA));
    }

    @Override
    public void backgroundImpl() {
        Paint savedFill = this.context.getFill();
        BlendMode savedBlend = this.context.getGlobalBlendMode();
        this.context.setFill((Paint)new Color((double)this.backgroundR, (double)this.backgroundG, (double)this.backgroundB, (double)this.backgroundA));
        this.context.setGlobalBlendMode(BlendMode.SRC_OVER);
        this.context.fillRect(0.0, 0.0, (double)this.width, (double)this.height);
        this.context.setFill(savedFill);
        this.context.setGlobalBlendMode(savedBlend);
    }

    @Override
    public void loadPixels() {
        int wide = this.width * this.pixelDensity;
        int high = this.height * this.pixelDensity;
        if (this.pixels == null || this.pixels.length != wide * high) {
            this.pixels = new int[wide * high];
        }
        SnapshotParameters sp = new SnapshotParameters();
        if (this.pixelDensity == 2) {
            sp.setTransform((Transform)Transform.scale((double)2.0, (double)2.0));
        }
        WritableImage wi = ((PSurfaceFX)this.surface).canvas.snapshot(sp, null);
        PixelReader pr = wi.getPixelReader();
        pr.getPixels(0, 0, wide, high, argbFormat, this.pixels, 0, wide);
    }

    @Override
    public void mask(PImage alpha) {
        PGraphicsFX2D.showWarning(MASK_WARNING);
    }

    public static void showTodoWarning(String method, int issue) {
        PGraphicsFX2D.showWarning(String.valueOf(method) + "() is not yet available: " + "https://github.com/processing/processing/issues/" + issue);
    }

    static class ImageCache {
        boolean tinted;
        int tintedColor;
        int[] tintedTemp;
        WritableImage image;

        ImageCache() {
        }

        public void update(PImage source, boolean tint, int tintColor) {
            boolean opaque;
            int targetType = 2;
            boolean bl = opaque = (tintColor & 0xFF000000) == -16777216;
            if (source.format == 1 && (!tint || tint && opaque)) {
                targetType = 1;
            }
            if (this.image == null) {
                this.image = new WritableImage(source.width, source.height);
            }
            PixelWriter pw = this.image.getPixelWriter();
            if (tint) {
                if (this.tintedTemp == null || this.tintedTemp.length != source.width) {
                    this.tintedTemp = new int[source.width];
                }
                int a2 = tintColor >> 24 & 0xFF;
                int r2 = tintColor >> 16 & 0xFF;
                int g2 = tintColor >> 8 & 0xFF;
                int b2 = tintColor & 0xFF;
                if (targetType == 1) {
                    int index = 0;
                    int y = 0;
                    while (y < source.height) {
                        int x = 0;
                        while (x < source.width) {
                            int argb1 = source.pixels[index++];
                            int r1 = argb1 >> 16 & 0xFF;
                            int g1 = argb1 >> 8 & 0xFF;
                            int b1 = argb1 & 0xFF;
                            this.tintedTemp[x] = 0xFF000000 | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                            ++x;
                        }
                        pw.setPixels(0, y, source.width, 1, argbFormat, this.tintedTemp, 0, source.width);
                        ++y;
                    }
                } else if (targetType == 2) {
                    if (source.format == 1 && (tintColor & 0xFFFFFF) == 0xFFFFFF) {
                        int hi = tintColor & 0xFF000000;
                        int index = 0;
                        int y = 0;
                        while (y < source.height) {
                            int x = 0;
                            while (x < source.width) {
                                this.tintedTemp[x] = hi | source.pixels[index++] & 0xFFFFFF;
                                ++x;
                            }
                            pw.setPixels(0, y, source.width, 1, argbFormat, this.tintedTemp, 0, source.width);
                            ++y;
                        }
                    } else {
                        int index = 0;
                        int y = 0;
                        while (y < source.height) {
                            int a1;
                            int b1;
                            int g1;
                            int r1;
                            int x;
                            if (source.format == 1) {
                                int alpha = tintColor & 0xFF000000;
                                x = 0;
                                while (x < source.width) {
                                    int argb1 = source.pixels[index++];
                                    r1 = argb1 >> 16 & 0xFF;
                                    g1 = argb1 >> 8 & 0xFF;
                                    b1 = argb1 & 0xFF;
                                    this.tintedTemp[x] = alpha | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                                    ++x;
                                }
                            } else if (source.format == 2) {
                                int x2 = 0;
                                while (x2 < source.width) {
                                    int argb1 = source.pixels[index++];
                                    a1 = argb1 >> 24 & 0xFF;
                                    r1 = argb1 >> 16 & 0xFF;
                                    g1 = argb1 >> 8 & 0xFF;
                                    b1 = argb1 & 0xFF;
                                    this.tintedTemp[x2] = (a2 * a1 & 0xFF00) << 16 | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                                    ++x2;
                                }
                            } else if (source.format == 4) {
                                int lower = tintColor & 0xFFFFFF;
                                x = 0;
                                while (x < source.width) {
                                    a1 = source.pixels[index++];
                                    this.tintedTemp[x] = (a2 * a1 & 0xFF00) << 16 | lower;
                                    ++x;
                                }
                            }
                            pw.setPixels(0, y, source.width, 1, argbFormat, this.tintedTemp, 0, source.width);
                            ++y;
                        }
                    }
                }
            } else {
                if (targetType == 1 && source.pixels[0] >> 24 == 0) {
                    source.filter(14);
                }
                pw.setPixels(0, 0, source.width, source.height, argbFormat, source.pixels, 0, source.width);
            }
            this.tinted = tint;
            this.tintedColor = tintColor;
        }
    }
}

