
// Module names are of the form poly_<inkscape-path-id>().  As a result,
// you can associate a polygon in this OpenSCAD program with the corresponding
// SVG element in the Inkscape document by looking for the XML element with
// the attribute id="inkscape-path-id".

// fudge value is used to ensure that subtracted solids are a tad taller
// in the z dimension than the polygon being subtracted from.  This helps
// keep the resulting .stl file manifold.
fudge = 0.1;

module poly_path2997(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-148.558461,5.575394],[-133.782871,5.575394],[-132.636168,5.442520],[-132.208812,5.126944],[-132.039564,4.512401],[-132.208812,3.897859],[-132.636168,3.582283],[-133.782871,3.449409],[-148.558461,3.449409],[-148.558461,-11.389960],[-148.691335,-12.532677],[-149.006911,-12.962524],[-149.621453,-13.133267],[-150.229850,-12.962524],[-150.542270,-12.532677],[-150.673815,-11.389960],[-150.673815,3.449409],[-165.502555,3.449409],[-166.653244,3.582283],[-167.078109,3.897859],[-167.245862,4.512401],[-167.078109,5.126944],[-166.653244,5.442520],[-165.502555,5.575394],[-150.673815,5.575394],[-150.673815,20.393503],[-150.542270,21.549507],[-150.229850,21.978026],[-149.621453,22.147440],[-149.006911,21.978026],[-148.691335,21.549507],[-148.558461,20.393503]]);
  }
}

module poly_path3021(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[192.895861,10.709645],[192.970271,10.709645],[193.034050,10.709645],[193.182869,10.699015],[193.331688,10.699015],[193.406098,10.699015],[193.480507,10.688386],[193.554917,10.677756],[193.629326,10.677756],[193.703735,10.667126],[193.767515,10.645866],[193.841924,10.635236],[193.916334,10.613976],[193.980113,10.592716],[194.043893,10.571456],[194.107672,10.550197],[194.171452,10.518307],[194.224602,10.486417],[194.288381,10.443897],[194.341531,10.401378],[194.384050,10.358858],[194.426570,10.305708],[194.447830,10.284449],[194.469090,10.252559],[194.490350,10.231299],[194.511609,10.199409],[194.532869,10.167519],[194.543499,10.135630],[194.564759,10.103740],[194.575389,10.071850],[194.586019,10.029330],[194.596649,9.997441],[194.607279,9.954921],[194.617909,9.912401],[194.628539,9.869882],[194.628539,9.827362],[194.639168,9.784842],[194.639168,9.742323],[194.639168,9.689173],[194.639168,9.646653],[194.469256,9.032111],[194.037249,8.716535],[192.853342,8.583661],[161.229327,8.583661],[160.032132,8.716535],[159.601454,9.032111],[159.432870,9.646653],[159.600624,10.261196],[160.025488,10.576771],[161.176177,10.709645]]);
  }
}

module poly_polyline3009(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[42.971456,-28.812401],[97.056494,-28.812401],[97.056494,-30.980905],[42.971456,-30.980905]]);
  }
}

module poly_path2999(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-99.767124,30.449409],[-99.767124,30.428149],[-99.767124,30.396259],[-99.767124,30.385629],[-99.767124,30.364369],[-99.777753,30.353739],[-99.777753,30.332480],[-99.788383,30.321850],[-99.788383,30.300590],[-99.799013,30.279330],[-99.809643,30.258070],[-99.820273,30.236810],[-99.841533,30.204921],[-99.852163,30.183661],[-99.873423,30.151771],[-99.894683,30.119881],[-99.926572,30.087991],[-99.947832,30.056102],[-99.979722,30.013582],[-100.000982,29.992322],[-100.022242,29.971062],[-100.032872,29.949802],[-100.054131,29.928543],[-100.075391,29.907283],[-100.096651,29.875393],[-100.117911,29.854133],[-100.139171,29.832873],[-100.171061,29.800984],[-100.192320,29.779724],[-100.213580,29.747834],[-100.245470,29.715944],[-100.277360,29.684054],[-100.298620,29.652165],[-100.330509,29.620275],[-100.362399,29.588385],[-100.394289,29.556495],[-100.436809,29.524606],[-100.468698,29.482086],[-100.500588,29.450196],[-100.543108,29.407676],[-100.574998,29.375787],[-100.617517,29.333267],[-100.660037,29.290747],[-102.915075,26.641655],[-104.746577,23.741929],[-106.192413,20.652857],[-107.290450,17.435728],[-108.594609,10.862451],[-108.962005,4.512401],[-108.546442,-2.360507],[-107.983264,-5.721223],[-107.144289,-8.990256],[-106.000368,-12.136712],[-104.522352,-15.129699],[-102.681092,-17.938324],[-100.447438,-20.531692],[-99.767124,-21.445866],[-99.906641,-21.845816],[-100.277360,-21.966732],[-101.379051,-21.300369],[-103.518157,-19.330511],[-106.141588,-16.101008],[-108.696257,-11.655708],[-110.361335,-7.293787],[-111.381641,-3.053445],[-111.893704,0.927793],[-112.034052,4.512401],[-111.898853,7.994863],[-111.382970,12.074262],[-110.320974,16.502454],[-108.547438,21.031299],[-105.993600,25.334922],[-103.423816,28.449655],[-101.348324,30.342611],[-100.277360,30.980905],[-99.906641,30.858661],[-99.767124,30.449409]]);
  }
}

module poly_path3023(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[227.889561,-16.152165],[227.889561,-16.205315],[227.889561,-16.269094],[227.889561,-16.322244],[227.889561,-16.375393],[227.889561,-16.428543],[227.889561,-16.481693],[227.889561,-16.524212],[227.878931,-16.577362],[227.878931,-16.619881],[227.878931,-16.662401],[227.878931,-16.704921],[227.878931,-16.747441],[227.878931,-16.789960],[227.878931,-16.821850],[227.868302,-16.864370],[227.868302,-16.896259],[227.857672,-16.970669],[227.847042,-17.034448],[227.836412,-17.087598],[227.825782,-17.140748],[227.804522,-17.193897],[227.783262,-17.236417],[227.762002,-17.278937],[227.730113,-17.310826],[227.708853,-17.342716],[227.666333,-17.374606],[227.634443,-17.406496],[227.591924,-17.427755],[227.538774,-17.449015],[227.517514,-17.459645],[227.496254,-17.470275],[227.464365,-17.470275],[227.432475,-17.480905],[227.411215,-17.491535],[227.379325,-17.491535],[227.336805,-17.502165],[227.304916,-17.502165],[227.273026,-17.512795],[227.230506,-17.512795],[227.198616,-17.512795],[227.156097,-17.523425],[227.113577,-17.523425],[227.071057,-17.523425],[227.028538,-17.523425],[226.986018,-17.523425],[226.932868,-17.523425],[226.890349,-17.534055],[226.837199,-17.534055],[226.784050,-17.534055],[226.730900,-17.534055],[226.677750,-17.534055],[224.020270,-15.573665],[221.259148,-14.566978],[218.796993,-14.196093],[217.036412,-14.143110],[217.036412,-12.495472],[219.871943,-12.668208],[221.876680,-13.078457],[223.967121,-13.877362],[223.967121,13.558464],[223.869458,14.762635],[223.297435,15.546259],[221.832499,15.971124],[219.056097,16.099015],[217.355310,16.099015],[217.355310,17.746653],[225.923026,17.576574],[234.512002,17.746653],[234.512002,16.099015],[232.821845,16.099015],[230.037636,15.978598],[228.565890,15.566191],[227.989051,14.785057],[227.889561,13.558464]]);
  }
}

module poly_path3011(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[60.999802,1.748622],[61.031691,1.610433],[61.074211,1.450984],[61.116731,1.280905],[61.159250,1.089567],[61.223030,0.887598],[61.286810,0.664370],[61.350589,0.430512],[61.435628,0.196654],[61.520668,-0.047835],[61.605707,-0.302953],[61.712006,-0.568701],[61.818306,-0.823819],[61.935235,-1.089567],[62.062794,-1.355315],[62.200983,-1.621063],[62.349802,-1.886811],[62.509250,-2.141929],[62.668699,-2.397047],[62.849408,-2.641535],[63.040746,-2.875394],[63.232085,-3.109252],[63.444683,-3.321850],[63.667912,-3.523819],[63.901770,-3.715157],[64.146258,-3.885236],[64.412006,-4.034055],[64.539565,-4.108464],[64.677754,-4.172244],[64.826573,-4.225394],[64.964762,-4.278543],[65.113581,-4.331693],[65.262400,-4.374212],[65.421849,-4.406102],[65.581298,-4.437992],[65.740746,-4.459252],[65.910825,-4.480512],[66.080904,-4.491142],[66.250983,-4.491142],[67.254181,-4.406102],[68.887203,-3.810827],[67.866897,-3.429810],[67.062843,-2.755807],[66.535831,-1.894451],[66.346652,-0.951378],[66.817026,0.293652],[67.440869,0.736288],[68.355707,0.908858],[69.295791,0.727817],[70.223916,0.170079],[70.932798,-0.786282],[71.215156,-2.163189],[70.698940,-3.873942],[69.429329,-4.942913],[67.824875,-5.493676],[66.304132,-5.649803],[64.221498,-5.192384],[62.598276,-4.095177],[61.435462,-2.770755],[60.734054,-1.631693],[59.495336,-3.730438],[57.951672,-4.948228],[56.372132,-5.512278],[55.025786,-5.649803],[53.074593,-5.353971],[51.362948,-4.562727],[49.897202,-3.420447],[48.683709,-2.071506],[47.038895,0.668855],[46.479330,2.503346],[46.759694,2.968405],[47.127755,3.034842],[47.587499,2.917913],[47.808070,2.450197],[49.422821,-1.002202],[51.358463,-3.125197],[53.294105,-4.195829],[54.908857,-4.491142],[55.780012,-4.370060],[56.711957,-3.873277],[57.454557,-2.800486],[57.757676,-0.951378],[57.066731,3.187648],[54.908857,11.655708],[54.093177,13.901777],[52.951623,15.640600],[51.529040,16.763552],[49.870274,17.162007],[48.851131,17.075639],[47.234054,16.471063],[48.183273,16.127417],[48.976032,15.507726],[49.519653,14.654841],[49.721455,13.611614],[49.527958,12.723351],[49.042469,12.157972],[47.765550,11.772638],[46.636121,12.013472],[45.706003,12.670866],[45.074851,13.647158],[44.842322,14.844685],[45.293927,16.411934],[46.462056,17.496850],[48.066676,18.127337],[49.827755,18.331299],[51.063753,18.171289],[52.147901,17.746819],[53.855166,16.437844],[55.387203,14.313189],[56.098245,15.766166],[57.288630,17.055708],[58.955369,17.978518],[61.095471,18.331299],[63.032172,18.035467],[64.732067,17.244223],[66.188553,16.101943],[67.395028,14.753002],[69.031537,12.012641],[69.588778,10.178149],[69.328345,9.713090],[68.940353,9.646653],[68.460677,9.798130],[68.260038,10.220669],[66.662560,13.695491],[64.720274,15.815994],[62.785961,16.874169],[61.212400,17.162007],[59.881169,16.869685],[58.973473,16.091043],[58.454434,14.973572],[58.289172,13.664763],[58.523030,11.771309],[59.203345,9.008858]]);
  }
}

module poly_path3001(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-71.013187,-2.428937],[-71.002557,-2.471457],[-70.991927,-2.503346],[-70.970668,-2.567126],[-70.960038,-2.620276],[-70.938778,-2.684055],[-70.928148,-2.737205],[-70.917518,-2.779724],[-70.906888,-2.832874],[-70.896258,-2.875394],[-70.885628,-2.917913],[-70.874998,-2.960433],[-70.864368,-3.002953],[-70.853738,-3.045472],[-70.853738,-3.077362],[-70.843109,-3.109252],[-70.843109,-3.141142],[-70.832479,-3.173031],[-70.832479,-3.204921],[-70.821849,-3.236811],[-70.821849,-3.289961],[-70.811219,-3.353740],[-70.811219,-3.406890],[-70.811219,-3.460039],[-70.811219,-3.513189],[-70.811219,-3.545079],[-70.811219,-3.576968],[-70.811219,-3.608858],[-70.811219,-3.640748],[-71.277607,-4.721014],[-72.341927,-5.075787],[-73.287990,-4.816683],[-74.202164,-3.959646],[-74.924998,-1.100197],[-75.987990,3.130512],[-78.379722,12.665551],[-78.906734,13.704460],[-80.132331,15.212746],[-81.977785,16.571549],[-83.108356,17.001500],[-84.364368,17.162007],[-86.012172,16.769199],[-87.015205,15.757529],[-87.513980,14.377134],[-87.649014,12.878149],[-86.968699,8.519882],[-84.949014,2.503346],[-84.098620,0.171407],[-83.886022,-1.323425],[-84.191632,-2.999465],[-85.063285,-4.375541],[-86.433216,-5.307154],[-88.233659,-5.649803],[-89.977776,-5.319528],[-91.447716,-4.444636],[-92.656308,-3.199025],[-93.616386,-1.756594],[-94.842314,1.023130],[-95.228147,2.503346],[-94.947783,2.968405],[-94.579722,3.034842],[-94.054870,2.870079],[-93.729328,2.067520],[-92.547082,-1.060501],[-91.199407,-3.081348],[-89.779981,-4.167427],[-88.382478,-4.491142],[-87.562645,-4.279872],[-87.203055,-3.778106],[-87.053738,-2.800984],[-87.367321,-0.830463],[-87.967911,0.908858],[-90.293206,7.641584],[-90.855928,10.034812],[-91.039958,12.038386],[-90.890434,13.657746],[-90.469597,15.003801],[-89.819054,16.094240],[-88.980411,16.946752],[-86.905251,18.008747],[-84.576966,18.331299],[-83.074826,18.167033],[-81.680313,17.694832],[-79.230116,15.950196],[-80.410037,20.004183],[-81.334841,22.035660],[-82.674211,24.113976],[-83.819086,25.388902],[-85.184201,26.452558],[-86.750619,27.181372],[-88.499407,27.451771],[-90.448669,27.108956],[-91.616133,26.438274],[-92.517517,25.219488],[-91.336267,25.138434],[-90.242714,24.571062],[-89.511907,23.695423],[-89.179722,22.413188],[-89.410591,21.427429],[-89.958364,20.865206],[-91.135628,20.552952],[-92.111920,20.726353],[-93.078246,21.302362],[-93.817357,22.364689],[-94.112006,23.997047],[-93.695446,25.839013],[-92.533462,27.300295],[-90.757601,28.263299],[-88.499407,28.610432],[-86.458712,28.390941],[-84.465352,27.761367],[-82.565669,26.765061],[-80.806002,25.445373],[-79.232691,23.845653],[-77.892075,22.009251],[-76.830495,19.979518],[-76.094289,17.799803]]);
  }
}

module poly_path3013(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[92.241139,-4.310433],[90.986809,-4.310433],[90.646651,-2.452854],[90.019486,-0.930118],[86.362793,-0.717520],[79.538384,-0.717520],[86.947439,-6.925394],[88.931580,-8.609738],[90.622734,-10.434596],[91.799666,-12.508593],[92.241139,-14.940354],[92.063773,-16.535361],[91.555676,-17.956096],[90.752847,-19.190724],[89.691287,-20.227411],[86.935978,-21.659627],[83.577754,-22.158070],[81.931216,-22.013030],[80.440765,-21.601660],[78.006347,-20.122440],[76.430959,-18.005425],[75.871061,-15.535630],[76.126179,-14.411848],[76.716140,-13.784350],[77.848226,-13.452165],[79.157035,-13.937155],[79.622593,-14.550867],[79.804132,-15.418700],[79.430756,-16.643799],[78.768213,-17.161675],[77.614368,-17.374606],[78.698952,-19.020417],[80.096455,-20.081250],[81.605571,-20.649784],[83.024998,-20.818700],[85.470378,-20.321751],[87.233118,-19.003641],[88.300262,-17.123474],[88.658856,-14.940354],[88.281494,-12.652762],[87.362006,-10.671112],[85.172242,-7.828937],[76.253738,0.993898],[75.918896,1.453642],[75.871061,2.439567],[91.135628,2.439567]]);
  }
}

module poly_path3003(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-22.189960,5.575394],[-22.019881,5.575394],[-21.849803,5.575394],[-21.690354,5.564764],[-21.605314,5.564764],[-21.520275,5.554134],[-21.445866,5.554134],[-21.360826,5.543504],[-21.286417,5.532874],[-21.212007,5.522244],[-21.137598,5.500984],[-21.063188,5.479724],[-20.988779,5.458464],[-20.924999,5.437205],[-20.861220,5.415945],[-20.797440,5.384055],[-20.733661,5.352165],[-20.680511,5.309646],[-20.627362,5.277756],[-20.584842,5.224606],[-20.531692,5.182086],[-20.499803,5.128937],[-20.478543,5.097047],[-20.457283,5.065157],[-20.446653,5.033268],[-20.425393,5.001378],[-20.414763,4.969488],[-20.393503,4.937598],[-20.382874,4.895079],[-20.372244,4.863189],[-20.361614,4.820669],[-20.350984,4.778149],[-20.350984,4.735630],[-20.340354,4.693110],[-20.340354,4.650590],[-20.329724,4.608071],[-20.329724,4.554921],[-20.329724,4.512401],[-20.494820,3.897859],[-20.924999,3.582283],[-22.189960,3.449409],[-50.837597,3.449409],[-52.101229,3.582283],[-52.525263,3.897859],[-52.687203,4.512401],[-52.525263,5.126944],[-52.101229,5.442520],[-50.837597,5.575394]]);
  }
}

module poly_path3015(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[112.693107,4.512401],[112.693107,4.119094],[112.682478,3.704527],[112.671848,3.289961],[112.661218,2.854134],[112.618698,1.961220],[112.554919,1.025787],[112.469879,0.047835],[112.352950,-0.962008],[112.214761,-1.993110],[112.034052,-3.066732],[111.832084,-4.150984],[111.587596,-5.245866],[111.300588,-6.362008],[110.981690,-7.488779],[110.609643,-8.626181],[110.184446,-9.763582],[109.961218,-10.326968],[109.727360,-10.890354],[109.472241,-11.453740],[109.206493,-12.017126],[106.649831,-16.316264],[104.084200,-19.431496],[102.014854,-21.326943],[100.947045,-21.966732],[100.565696,-21.825885],[100.415549,-21.445866],[101.414761,-20.223425],[103.260693,-18.113302],[104.893237,-15.709694],[106.302303,-13.019079],[107.477802,-10.047933],[108.409644,-6.802734],[109.087737,-3.289961],[109.642320,4.512401],[109.232238,11.303094],[107.836562,17.923376],[106.691583,21.083971],[105.207152,24.099194],[103.352251,26.934787],[101.095864,29.556495],[100.415549,30.449409],[100.565696,30.834743],[100.947045,30.980905],[102.045913,30.312881],[104.181198,28.339369],[106.806789,25.106212],[109.376572,20.659251],[111.029359,16.309621],[112.043354,12.075590],[112.553091,8.096678],[112.693107,4.512401]]);
  }
}

module poly_path3005(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[19.394291,-18.575787],[19.617519,-18.575787],[19.840748,-18.554527],[20.053346,-18.533267],[20.265944,-18.512007],[20.478543,-18.469488],[20.669881,-18.416338],[20.871850,-18.363189],[21.052559,-18.299409],[21.243897,-18.225000],[21.413976,-18.150590],[21.584055,-18.054921],[21.754133,-17.959252],[21.902952,-17.852952],[22.051771,-17.746653],[22.200590,-17.619094],[22.338779,-17.491535],[22.466338,-17.353346],[22.583267,-17.215157],[22.700196,-17.066338],[22.806496,-16.906889],[22.912795,-16.736811],[22.997834,-16.566732],[23.082873,-16.386023],[23.157283,-16.194685],[23.221062,-16.003346],[23.284842,-15.801378],[23.327362,-15.588779],[23.369881,-15.376181],[23.401771,-15.152952],[23.433661,-14.919094],[23.444291,-14.685236],[23.444291,-14.440748],[23.148314,-12.651101],[22.320177,-11.356742],[21.049569,-10.570626],[19.426181,-10.305708],[17.419783,-10.478445],[15.904355,-10.888693],[14.632086,-11.687598],[15.744242,-12.314763],[16.035236,-13.292716],[15.552903,-14.472637],[14.408858,-14.919094],[13.280758,-14.499212],[12.918510,-13.977350],[12.782480,-13.250197],[12.923762,-12.283580],[13.326765,-11.454736],[14.792864,-10.199409],[16.930641,-9.462291],[19.489960,-9.221456],[22.431459,-9.671733],[24.653444,-10.854478],[26.058255,-12.517562],[26.548228,-14.408858],[26.198603,-15.969961],[25.202214,-17.330757],[23.637789,-18.410525],[21.584055,-19.128543],[23.560556,-20.063312],[24.799606,-21.225295],[25.440723,-22.470989],[25.623425,-23.656889],[25.147736,-25.167501],[23.850885,-26.366190],[21.928198,-27.156292],[19.575000,-27.441141],[17.284252,-27.189511],[15.416043,-26.456545],[14.157726,-25.275129],[13.696653,-23.678149],[13.862247,-22.909307],[14.264025,-22.430462],[15.206102,-22.115551],[16.247834,-22.515501],[16.715551,-23.624999],[16.443159,-24.555118],[15.461220,-25.134448],[16.489831,-25.848314],[17.694832,-26.237303],[19.489960,-26.431299],[20.830493,-26.250424],[21.883021,-25.717765],[22.570810,-24.848271],[22.817125,-23.656889],[22.615987,-22.386448],[21.965403,-21.083120],[20.794617,-20.040889],[19.032874,-19.553740],[17.480905,-19.468700],[17.090255,-19.384990],[16.906889,-19.022244],[17.099557,-18.631594],[17.650984,-18.575787]]);
  }
}

module poly_path2993(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-218.354522,1.748622],[-218.322632,1.610433],[-218.280113,1.450984],[-218.237593,1.280905],[-218.195073,1.089567],[-218.131294,0.887598],[-218.067514,0.664370],[-218.003735,0.430512],[-217.929325,0.196654],[-217.844286,-0.047835],[-217.748617,-0.302953],[-217.642318,-0.568701],[-217.536018,-0.823819],[-217.419089,-1.089567],[-217.291530,-1.355315],[-217.153341,-1.621063],[-217.004522,-1.886811],[-216.845073,-2.141929],[-216.685625,-2.397047],[-216.504916,-2.641535],[-216.313577,-2.875394],[-216.122239,-3.109252],[-215.909640,-3.321850],[-215.686412,-3.523819],[-215.452554,-3.715157],[-215.208066,-3.885236],[-214.942318,-4.034055],[-214.814759,-4.108464],[-214.676570,-4.172244],[-214.527751,-4.225394],[-214.389562,-4.278543],[-214.240743,-4.331693],[-214.091924,-4.374212],[-213.932475,-4.406102],[-213.773026,-4.437992],[-213.613577,-4.459252],[-213.443499,-4.480512],[-213.273420,-4.491142],[-213.103341,-4.491142],[-212.100142,-4.406102],[-210.467121,-3.810827],[-211.487427,-3.429810],[-212.291481,-2.755807],[-212.818493,-1.894451],[-213.007672,-0.951378],[-212.537298,0.293652],[-211.913454,0.736288],[-210.998617,0.908858],[-210.058533,0.727817],[-209.130408,0.170079],[-208.421525,-0.786282],[-208.139168,-2.163189],[-208.655550,-3.873942],[-209.926324,-4.942913],[-211.533933,-5.493676],[-213.060822,-5.649803],[-215.137310,-5.192384],[-216.757377,-4.095177],[-217.919028,-2.770755],[-218.620270,-1.631693],[-219.858988,-3.730438],[-221.402652,-4.948228],[-222.982192,-5.512278],[-224.328538,-5.649803],[-226.279730,-5.353971],[-227.991376,-4.562727],[-229.457122,-3.420447],[-230.670614,-2.071506],[-232.315429,0.668855],[-232.874994,2.503346],[-232.594630,2.968405],[-232.226569,3.034842],[-231.766825,2.917913],[-231.546254,2.450197],[-229.931503,-1.002202],[-227.995861,-3.125197],[-226.060218,-4.195829],[-224.445467,-4.491142],[-223.574312,-4.370060],[-222.642367,-3.873277],[-221.899767,-2.800486],[-221.596648,-0.951378],[-222.287593,3.187648],[-224.445467,11.655708],[-225.262642,13.901777],[-226.406687,15.640600],[-227.829768,16.763552],[-229.484050,17.162007],[-230.507179,17.075639],[-232.120270,16.471063],[-231.171051,16.127417],[-230.378292,15.507726],[-229.834671,14.654841],[-229.632868,13.611614],[-229.826366,12.723351],[-230.311855,12.157972],[-231.588774,11.772638],[-232.718203,12.013472],[-233.648321,12.670866],[-234.279473,13.647158],[-234.512002,14.844685],[-234.060563,16.411934],[-232.893597,17.496850],[-231.292133,18.127337],[-229.537199,18.331299],[-228.297692,18.171289],[-227.210907,17.746819],[-225.500487,16.437844],[-223.967121,14.313189],[-223.256078,15.766166],[-222.065693,17.055708],[-220.398955,17.978518],[-218.258853,18.331299],[-216.325204,18.035467],[-214.626742,17.244223],[-213.170443,16.101943],[-211.963282,14.753002],[-210.324281,12.012641],[-209.765546,10.178149],[-210.025979,9.713090],[-210.413971,9.646653],[-210.893646,9.798130],[-211.094286,10.220669],[-212.691764,13.695491],[-214.634050,15.815994],[-216.568363,16.874169],[-218.141924,17.162007],[-219.473155,16.869685],[-220.380851,16.091043],[-220.899890,14.973572],[-221.065152,13.664763],[-220.831294,11.771309],[-220.150979,9.008858]]);
  }
}

module poly_path3017(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[136.631690,-8.126575],[135.377359,-8.126575],[135.033215,-6.274311],[134.410036,-4.756890],[130.753343,-4.544291],[123.928934,-4.544291],[131.337989,-10.752165],[133.322130,-12.431859],[135.013284,-14.256053],[136.190216,-16.329386],[136.631690,-18.756496],[136.454324,-20.355011],[135.946226,-21.778383],[135.143397,-23.014900],[134.081837,-24.052854],[131.326529,-25.486232],[127.968304,-25.984842],[126.321767,-25.839802],[124.831315,-25.428432],[122.396897,-23.949212],[120.821509,-21.832197],[120.261611,-19.362401],[120.516729,-18.234135],[121.106690,-17.607135],[122.238777,-17.278937],[123.547586,-17.763927],[124.013143,-18.377639],[124.194682,-19.245472],[123.821306,-20.470570],[123.158763,-20.988447],[122.004918,-21.201377],[123.089502,-22.845527],[124.487005,-23.902706],[125.996121,-24.467587],[127.415548,-24.634842],[129.860928,-24.139388],[131.623668,-22.823769],[132.690812,-20.944100],[133.049406,-18.756496],[132.672044,-16.475049],[131.752556,-14.496555],[129.562792,-11.655708],[120.644288,-2.832874],[120.309446,-2.373130],[120.261611,-1.387205],[135.526178,-1.387205]]);
  }
}

module poly_path3007(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[19.776968,16.715551],[10.454527,-3.874606],[9.984153,-4.618701],[9.657283,-4.725000],[8.764370,-4.310433],[3.725787,-0.494291],[3.045472,0.356102],[3.167716,0.748081],[3.576968,0.940748],[5.373425,-0.228543],[7.063583,-1.504134],[17.491535,21.435236],[18.025689,22.179330],[18.607677,22.285629],[19.435482,22.033169],[19.936417,21.222637],[43.991928,-28.557283],[44.353345,-29.620275],[44.061023,-30.351082],[43.290353,-30.683267],[42.684448,-30.444094],[42.078542,-29.567125]]);
  }
}

module poly_path2995(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-187.113184,-8.126575],[-188.367515,-8.126575],[-188.711659,-6.274311],[-189.334838,-4.756890],[-192.991531,-4.544291],[-199.815940,-4.544291],[-192.406885,-10.752165],[-190.422744,-12.431859],[-188.731590,-14.256053],[-187.554658,-16.329386],[-187.113184,-18.756496],[-187.290550,-20.355011],[-187.798648,-21.778383],[-188.601477,-23.014900],[-189.663037,-24.052854],[-192.418345,-25.486232],[-195.776570,-25.984842],[-197.423107,-25.839802],[-198.913559,-25.428432],[-201.347977,-23.949212],[-202.923365,-21.832197],[-203.483263,-19.362401],[-203.228145,-18.234135],[-202.638184,-17.607135],[-201.506097,-17.278937],[-200.197288,-17.763927],[-199.731731,-18.377639],[-199.550192,-19.245472],[-199.923568,-20.470570],[-200.586111,-20.988447],[-201.739956,-21.201377],[-200.655372,-22.845527],[-199.257869,-23.902706],[-197.748753,-24.467587],[-196.329326,-24.634842],[-193.883946,-24.139388],[-192.121206,-22.823769],[-191.054062,-20.944100],[-190.695468,-18.756496],[-191.072830,-16.475049],[-191.992318,-14.496555],[-194.182082,-11.655708],[-203.100586,-2.832874],[-203.435428,-2.373130],[-203.483263,-1.387205],[-188.218696,-1.387205]]);
  }
}

module poly_path3019(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[192.853342,0.419882],[193.002161,0.419882],[193.150980,0.419882],[193.299798,0.419882],[193.384838,0.409252],[193.459247,0.409252],[193.533657,0.398622],[193.608066,0.387992],[193.682476,0.377362],[193.756885,0.366732],[193.831294,0.356102],[193.905704,0.334843],[193.969483,0.313583],[194.043893,0.292323],[194.107672,0.271063],[194.160822,0.239173],[194.224602,0.207283],[194.277751,0.164764],[194.330901,0.132874],[194.384050,0.079724],[194.426570,0.037205],[194.469090,-0.015945],[194.490350,-0.047835],[194.511609,-0.079724],[194.532869,-0.100984],[194.543499,-0.132874],[194.564759,-0.164764],[194.575389,-0.207283],[194.586019,-0.239173],[194.596649,-0.281693],[194.607279,-0.313583],[194.617909,-0.356102],[194.628539,-0.398622],[194.628539,-0.441142],[194.639168,-0.483661],[194.639168,-0.526181],[194.639168,-0.568701],[194.639168,-0.621850],[194.469920,-1.236393],[194.042564,-1.551968],[192.895861,-1.684842],[161.176177,-1.684842],[160.025488,-1.551968],[159.600624,-1.236393],[159.432870,-0.621850],[159.601454,-0.019599],[160.032132,0.289665],[161.229327,0.419882]]);
  }
}

poly_path2997(10);
poly_path3021(10);
poly_polyline3009(10);
poly_path2999(10);
poly_path3023(10);
poly_path3011(10);
poly_path3001(10);
poly_path3013(10);
poly_path3003(10);
poly_path3015(10);
poly_path3005(10);
poly_path2993(10);
poly_path3017(10);
poly_path3007(10);
poly_path2995(10);
poly_path3019(10);

translate([0,0,3]) cube([150,30,6], center=true);
