#include "arduino.h"

int motor[2][3] = {{PAN_MOTOR_PIN_0, PAN_MOTOR_PIN_1, PAN_MOTOR_INVERSE}, {TILT_MOTOR_PIN_0, TILT_MOTOR_PIN_1, TILT_MOTOR_INVERSE}};
int LDRPin[] =  {LDR_L_U_PIN, LDR_R_U_PIN, LDR_L_D_PIN, LDR_R_D_PIN};
int LDRVal[4];
#define PAN   0
#define TILT  1

#define PIN_0    0
#define PIN_1   1
#define INVERSE   2

#define LEFT_UP_LDR  0
#define RIGHT_UP_LDR 1
#define LEFT_DOWN_LDR  2
#define RIGHT_DOWN_LDR 3

#define LEFT   0
#define RIGHT  1
#define UP   0
#define DOWN   1

#define AVERAGE_LEFT  LDRVal[LEFT_UP_LDR]+LDRVal[LEFT_DOWN_LDR]
#define AVERAGE_RIGHT LDRVal[RIGHT_UP_LDR]+LDRVal[RIGHT_DOWN_LDR]
#define AVERAGE_UP  LDRVal[LEFT_UP_LDR]+LDRVal[RIGHT_UP_LDR]
#define AVERAGE_DOWN  LDRVal[LEFT_DOWN_LDR]+LDRVal[RIGHT_DOWN_LDR]

void stopMotor(int motorName) {
  //Serial.print("Stop\t");
  digitalWrite(motor[motorName][PIN_0], LOW);
  digitalWrite(motor[motorName][PIN_1], LOW);
}
void turnMotor(int motorName, int dir) {
  if (motorName == PAN) {
    if (dir == LEFT) {
      //Serial.print("LEFT");
    } else if (dir == RIGHT) {
      //Serial.print("RIGHT");
    }
  } else  if (motorName == TILT) {
    if (dir == UP) {
      //Serial.print("UP");
    } else if (dir == DOWN) {
      //Serial.print("DOWN");
    }
  }
  //Serial.print("\t");
  if ((digitalRead(PAN_ENDLIMIT_PIN) == HIGH)) {
    stopMotor(PAN);
  }
  if ((motorName == PAN) && (dir == LEFT) && (digitalRead(PAN_ENDLIMIT_PIN) == HIGH)) {
    stopMotor(PAN);
  } else {
    if ( motor[motorName][INVERSE] == 1) {
      dir = ! dir; //To reverse the direction is invert is enabled
    }
    /* //Serial.print(motor[motorName][PIN_1]);
     //Serial.print(":");
     //Serial.print(dir);
     //Serial.print("-");

     //Serial.print(motor[motorName][PIN_0]);*/

    digitalWrite(motor[motorName][PIN_1], dir);         //stelt de richting in
    digitalWrite(motor[motorName][PIN_0], !dir); //zet de motor aan}
  }
}

void stopMotors() { //this function stops every motor
  //Serial.print("Stop\t");
  stopMotor(0);
  stopMotor(1);
}

void turnToLight(int motorName, int value1, int value2, int side1, int side2) {
  if (abs(value1 - value2) > TOLLERANCE_ON) {
    turnMotor(motorName, (value1 < value2) ? side1 : side2); //>
  }
  else if (abs(value1 - value2) < TOLLERANCE_OFF) {
    stopMotor(motorName);
  }
}

void readLDRVal() { //This function updates all the LDR values and stores them in an array
  for (int i = 0; i < 4; i++) {
    LDRVal[i] = analogRead(LDRPin[i]);
    //Serial.print("LDR");
    //Serial.print(i);
    //Serial.print(": ");
    //Serial.print(LDRVal[i]);
    //Serial.print('\t');
  }
  ////Serial.println();
}
