#include "Arduino.h"
#include "EnergyMonitor.h"
#include "EnergyMonConnections.h"
EnergyMonitor::EnergyMonitor() {
  _panel[0].VSensPin(PANEL_0_V_PIN);
  _panel[1].VSensPin(PANEL_1_V_PIN);
  
  _panel[0].ISensPin(PANEL_0_I_PIN);
  _panel[1].ISensPin(PANEL_1_I_PIN);

  _panel[0].VSenseFactor(VoltageFactor);
  _panel[1].VSenseFactor(VoltageFactor);

  _panel[0].ISenseFactor(A_PER_V);
  _panel[1].ISenseFactor(A_PER_V);
  _energyWS[0] = 0;
  _energyWS[1] = 0;
}


void EnergyMonitor::ISRupdate() {
 // //Serial.println((double)1000.000 * _panel[0].power() / 1000.000);
  _energyWS[0] += (double)100.000 * _panel[0].power() / 1000.000;
  _energyWS[1] += (double)100.000 * _panel[1].power() / 1000.000;
}

double EnergyMonitor::voltage(int panel) {
  return _panel[panel].voltage();
}
double EnergyMonitor::current(int panel) {
  return _panel[panel].current();
}
double EnergyMonitor::power(int panel) {
  return _panel[panel].power();
}
double EnergyMonitor::power() {
  return _panel[0].power() + _panel[1].power();
}
double EnergyMonitor::energyWS(int panel) {
  return _energyWS[panel];
}
double EnergyMonitor::energyWS() {
  return _energyWS[0] + _energyWS[1];
}
