
/*
 * The Flickering Unicorn
 *
 * Liza Stark 
 * Fall 2016
 *
 * Reads values coming in from a stroke sensor that acts as the
 * unicorn's mane. If values are below 5, the fade behavior is 
 * slow. If it is above 5 the fade speed increases.  
 * 
 * To make sure we are constantly listening to the sensor, we can't
 * use a delay() in our code. Instead, we will use millis() to handle
 * PWM without delay():
 *
 * From Christian Liljedahl
 * http://arduino.cc/forum/index.php/topic,12004.msg91555.html#msg91555
 * Reply #6 to the post
 * This is a simple example I use:
 * Basicly the idea is:
 *  - Use millis() to get the "time"
 *  - Use a sin/cos function to determine the fade-level of the diode.
 * Benefit of using sinus is, that you get a much more smooth and pretty fade.
 * Linear fade is dull. :-)

 *
 */

int sensorPin = 11;    // input pin for the sensor; this is D12 on the Flora
int sensorValue = 0;  // variable to store the value coming from the sensor
int newSensorValue;

int threshold = 5; // change this based on your readings

int valueR, valueG, valueB ;
int green = 9;                           
int blue = 10;                          
int red = 6;
long time = 0;


void setup()
{
  // declare the ledPin as an OUTPUT:
  pinMode(sensorPin, INPUT);
  pinMode(green, OUTPUT);
  pinMode(blue, OUTPUT);
  pinMode(red, OUTPUT);
  digitalWrite(green, HIGH);
  digitalWrite(blue, HIGH);
  digitalWrite(red, HIGH);

  Serial.begin(9600);
}

void loop()
{
  time = millis();

  // read the value from the sensor:
  sensorValue = analogRead(sensorPin);

  if (sensorValue > threshold) {
    rgbFade(50, 200); // slow fade

  } else if (sensorValue < threshold) {
    rgbFade(4000, 200); // super fast fade
  }

  Serial.println(sensorValue);

}

void rgbFade(int period, int displace) {

  valueG = 128 + 127 * cos(2 * PI / period * time);
  valueB = 128 + 127 * cos(2 * PI / period * (displace - (time * .9)));
  valueR = 128 + 127 * cos(2 * PI / period * (displace - (time * .3)));
  analogWrite(green, valueG);           // sets the value (range from 0 to 255)
  analogWrite(blue, valueB);           // sets the value (range from 0 to 255)
  analogWrite(red, valueR);
}



