#include <Adafruit_NeoPixel.h>

#define PIN 3         //data pin of LED strip
#define IN 4          //input button grounding when pushed

#define NUMBER 29     //number of LEDs in strip
#define PROGRAMS 6    //number of programs if new ones are written

//    CANDLES
#define CANDLES 1     //number of candles in candle program
#define SPEEDC 5      //speed of candles
#define MAXC 70       //maximum light intensity
#define MINC 50       //minimum light intensity
#define MAXCV 2       //maximum of delta light (exclusive)
#define MINCV 1       //minimum of delta light (inclusive)
#define CORRC 30      //secondary light correlation
#define MINCS 5       //minimum secondary light intensity
#define REDDERC 15    //red to 3*yellow

#define SPEED0 10     //speed settings
#define SPEED1 20
#define SPEED2 50
#define SPEED3 100

//    FIREPLACE
#define SPEEDF 2      //speed of fireplace
#define MAXF 70       //maximum light intensity
#define MINF 5        //minimum light intensity
#define MAXFV 4       //maximum of delta light (exclusive)
#define MINFV 1       //minimum of delta light (inclusive)
#define CORRF 16      //adjacent flame correlation
#define REDDERF 30    //red to 3*yellow

//    FIREPLACE Dying
#define MAXFD 70       //maximum light intensity
#define MAXTOFD 5      //maximum light intensity in the end
#define MINFD 1        //minimum light intensity
#define TIMED 500      //time of dying

//    COLORTHEME
#define SIZECT 5
#define SPEEDCT 100

#define CRED strip.Color(255, 0, 0)
#define CORANGE strip.Color(255, 70, 0)
#define CYELLOW strip.Color(255, 180, 0)
#define CGREEN strip.Color(0, 255, 0)
#define CCYAN strip.Color(0, 255, 255)
#define CBLUE strip.Color(0, 0, 255)
#define CPURPLE strip.Color(100, 0, 255)
#define CPINK strip.Color(255, 0, 255)

Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUMBER, PIN, NEO_GRB + NEO_KHZ800);         //strip initialization

int program = 0;      //program counter
int ph = 0,           //program counter help1
    pa = 0;           //program counter help2

//  Fireplace starting values
int values[] = {30,38,46,54,62,70,66,61,56,48,50,57,63,70,68,60,68,70,66,60,55,48,40,48,42,38,32,26,20};
int valuesd[] = {30,38,46,54,62,70,66,61,56,48,50,57,63,70,68,60,68,70,66,60,55,48,40,48,42,38,32,26,20};
int dead = MAXFD;

//  Candle starting value
int candle = 50;

//  Colorwipe colors
uint32_t colors[] = {CRED,
                     CORANGE,
                     CYELLOW,
                     CGREEN,
                     CCYAN,
                     CBLUE,
                     CPURPLE,
                     CPINK};

// Colortheme colors
uint32_t ctheme[] = {CGREEN,
                     CRED};

void setup() {
  pinMode(IN, INPUT_PULLUP);
  strip.begin();
  strip.show();
}

void loop() {
  
  //////////////////////////////////////////////////////////////////    Program counter step
  if(button(IN) == 1){
    program++;
    ph = 0;
    pa = 0;
    if(program >= PROGRAMS){
      program = 0;
      for(int i=0; i<NUMBER; i++){
        valuesd[i] = MAXFD;
      }
      dead = MAXFD;
    }
  }
  
  //////////////////////////////////////////////////////////////////    Colorwipe speed 3
  if(program == 0){
    if(ph == (sizeof(colors)/sizeof(uint32_t))){
      ph = 0;
    }
    showP(pa, colors[ph], SPEED3);
    pa++;
    if(pa == NUMBER){
      pa = 0;
      ph++;
    }
  }
  
  //////////////////////////////////////////////////////////////////    Colorwipe speed 2
  if(program == 1){
    if(ph == (sizeof(colors)/sizeof(uint32_t))){
      ph = 0;
    }
    showP(pa, colors[ph], SPEED2);
    pa++;
    if(pa == 29){
      pa = 0;
      ph++;
    }
  }
  
  //////////////////////////////////////////////////////////////////    Fireplace
  if(program == 2){
    writeF();
    for(int i=0; i<NUMBER; i++){
      int s = int(random(2));
      int v = int(random(MINFV,MAXFV));
      if(s == 0){
        v = -v;
      }
      values[i] = values[i] + v;
      if(values[i] > MAXF){
        values[i] = MAXF;
      }
      if(values[i] < MINF){
        values[i] = MINF;
      }
      if(i != 0){
        if(values[i] > values[i-1] + CORRF){
          values[i] = values[i-1] + CORRF;
        }
        if(values[i] < values[i-1] - CORRF){
          values[i] = values[i-1] - CORRF;
        }
      }
    }
  }
  
  //////////////////////////////////////////////////////////////////    Candles
  if(program == 3){
    writeC();
    for(int i=0; i<CANDLES; i++){
      int s = int(random(2));
      int v = int(random(MINCV,MAXCV));
      if(s == 0){
        v = -v;
      }
      candle = candle + v;
      if(candle > MAXC){
        candle = MAXC;
      }
      if(candle < MINC){
        candle = MINC;
      }
    }
  }
  
  //////////////////////////////////////////////////////////////////    Colortheme
  if(program == 4){
    writeCT(pa);
    pa++;
    if(pa == ((sizeof(ctheme)/sizeof(uint32_t))*SIZECT)){
      pa = 0;
    }
  }
  
  //////////////////////////////////////////////////////////////////    Dying Fireplace
  if(program == 5){
    writeFD();
    for(int i=0; i<NUMBER; i++){
      int s = int(random(2));
      int v = int(random(MINFV,MAXFV));
      if(s == 0){
        v = -v;
      }
      valuesd[i] = valuesd[i] + v;
      if(valuesd[i] > dead){
        valuesd[i] = dead;
      }
      if(valuesd[i] < MINFD){
        valuesd[i] = MINFD;
      }
      if(i != 0){
        if(valuesd[i] > valuesd[i-1] + CORRF){
          valuesd[i] = valuesd[i-1] + CORRF;
        }
        if(valuesd[i] < valuesd[i-1] - CORRF){
          valuesd[i] = valuesd[i-1] - CORRF;
        }
      }
    }
    pa++;
    if(pa >= TIMED){
      pa = 0;
      dead = dead - 1;
      if(dead <= MAXTOFD){
        dead = MAXTOFD;
      }
    }
  }
}
































