
/*
 * The Flickering Unicorn
 *
 * Liza Stark
 * Fall 2016
 *
 * From Christian Liljedahl
 * http://arduino.cc/forum/index.php/topic,12004.msg91555.html#msg91555
 * Reply #6 to the post
 * This is a simple example I use:
 * Basicly the idea is:
 *  - Use millis() to get the "time"
 *  - Use a sin/cos function to determine the fade-level of the diode.
 * Benefit of using sinus is, that you get a much more smooth and pretty fade.
 * Linear fade is dull. :-)

 *
 */


int valueR, valueG, valueB ;
int green = 9;
int blue = 10;
int red = 6;
long time = 0;


void setup()
{
  pinMode(green, OUTPUT);
  pinMode(blue, OUTPUT);
  pinMode(red, OUTPUT);
  digitalWrite(green, HIGH);
  digitalWrite(blue, HIGH);
  digitalWrite(red, HIGH);

}

void loop()
{
  time = millis();

// change these values to adjust the fade speed. 
// for a fast fade I used rgbFade(4000, 200).
// the slower fade uses rgbFade(50, 200);
  
  rgbFade(50, 200); // slow fade

}

void rgbFade(int period, int displace) {

  valueG = 128 + 127 * cos(2 * PI / period * time);
  valueB = 128 + 127 * cos(2 * PI / period * (displace - (time * .9)));
  valueR = 128 + 127 * cos(2 * PI / period * (displace - (time * .3)));
  analogWrite(green, valueG);           // sets the value (range from 0 to 255)
  analogWrite(blue, valueB);           // sets the value (range from 0 to 255)
  analogWrite(red, valueR);
}



