/*
 * wiznet5100.h
 *
 *  Created on: May 24, 2011
 *      Author: Justin
 */

#ifndef WIZNET5100_H_
#define WIZNET5100_H_

#include "stm32f10x.h"

typedef uint8_t ipaddress_t[4];
typedef uint8_t subnetmask_t[4];
typedef uint8_t macaddress_t[6];

typedef enum
{
	// common registers
	MR = 0x0000, // mode
	GAR0, // gateway address
	GAR1,
	GAR2,
	GAR3,
	SUBR0, // subnet mask address
	SUBR1,
	SUBR2,
	SUBR3,
	SHAR0, // source hardware address
	SHAR1,
	SHAR2,
	SHAR3,
	SHAR4,
	SHAR5,
	SIPR0, // source ip address
	SIPR1,
	SIPR2,
	SIPR3,
	IR = 0x0015, // interrupt
	IMR, // interrupt mask
	RTR0, // retry time
	RTR1,
	RCR, // retry count
	RMSR, // rx memory size
	TMSR, // tx memory size
	PATR0, // authentication type in PPPoE
	PATR1,
	PTIMER = 0x0028, // PPP LCP request timer
	PMAGIC, // PPP LCP magic number
	UIPR0, // unreachable IP address
	UIPR1,
	UIPR2,
	UIPR3,
	UPORT0, // unreachable port
	UPORT1,

	// socket registers (socket 0)
	S0_MR = 0x0400, // mode
	S0_CR, // command
	S0_IR, // interrupt
	S0_SR, // status
	S0_PORT0, // source port
	S0_PORT1,
	S0_DHAR0, // destination hardware address
	S0_DHAR1,
	S0_DHAR2,
	S0_DHAR3,
	S0_DHAR4,
	S0_DHAR5,
	S0_DIPR0, // destination IP address
	S0_DIPR1,
	S0_DIPR2,
	S0_DIPR3,
	S0_DPORT0, // destination port
	S0_DPORT1,
	S0_MSSR0, // maximum segment size
	S0_MSSR1,
	S0_PROTO, // protocol in IP raw mode
	S0_TOS, // IP TOS
	S0_TTL, // IP TTL
	S0_TX_FSR0 = 0x0420, // Tx free size
	S0_TX_FSR1,
	S0_TX_RD0, // Tx read pointer
	S0_TX_RD1,
	S0_TX_WR0, // Tx write pointer
	S0_TX_WR1,
	S0_RX_RSR0, // Rx received size
	S0_RX_RSR1,
	S0_RX_RD0, // Rx read pointer
	S0_RX_RD1,

	// socket registers (socket 1)
	S1_MR = 0x0500, // mode
	S1_CR, // command
	S1_IR, // interrupt
	S1_SR, // status
	S1_PORT0, // source port
	S1_PORT1,
	S1_DHAR0, // destination hardware address
	S1_DHAR1,
	S1_DHAR2,
	S1_DHAR3,
	S1_DHAR4,
	S1_DHAR5,
	S1_DIPR0, // destination IP address
	S1_DIPR1,
	S1_DIPR2,
	S1_DIPR3,
	S1_DPORT0, // destination port
	S1_DPORT1,
	S1_MSSR0, // maximum segment size
	S1_MSSR1,
	S1_PROTO, // protocol in IP raw mode
	S1_TOS, // IP TOS
	S1_TTL, // IP TTL
	S1_TX_FSR0 = 0x0520, // Tx free size
	S1_TX_FSR1,
	S1_TX_RD0, // Tx read pointer
	S1_TX_RD1,
	S1_TX_WR0, // Tx write pointer
	S1_TX_WR1,
	S1_RX_RSR0, // Rx received size
	S1_RX_RSR1,
	S1_RX_RD0, // Rx read pointer
	S1_RX_RD1,

	// socket registers (socket 2)
	S2_MR = 0x0600, // mode
	S2_CR, // command
	S2_IR, // interrupt
	S2_SR, // status
	S2_PORT0, // source port
	S2_PORT1,
	S2_DHAR0, // destination hardware address
	S2_DHAR1,
	S2_DHAR2,
	S2_DHAR3,
	S2_DHAR4,
	S2_DHAR5,
	S2_DIPR0, // destination IP address
	S2_DIPR1,
	S2_DIPR2,
	S2_DIPR3,
	S2_DPORT0, // destination port
	S2_DPORT1,
	S2_MSSR0, // maximum segment size
	S2_MSSR1,
	S2_PROTO, // protocol in IP raw mode
	S2_TOS, // IP TOS
	S2_TTL, // IP TTL
	S2_TX_FSR0 = 0x0620, // Tx free size
	S2_TX_FSR1,
	S2_TX_RD0, // Tx read pointer
	S2_TX_RD1,
	S2_TX_WR0, // Tx write pointer
	S2_TX_WR1,
	S2_RX_RSR0, // Rx received size
	S2_RX_RSR1,
	S2_RX_RD0, // Rx read pointer
	S2_RX_RD1,

	// socket registers (socket 3)
	S3_MR = 0x0700, // mode
	S3_CR, // command
	S3_IR, // interrupt
	S3_SR, // status
	S3_PORT0, // source port
	S3_PORT1,
	S3_DHAR0, // destination hardware address
	S3_DHAR1,
	S3_DHAR2,
	S3_DHAR3,
	S3_DHAR4,
	S3_DHAR5,
	S3_DIPR0, // destination IP address
	S3_DIPR1,
	S3_DIPR2,
	S3_DIPR3,
	S3_DPORT0, // destination port
	S3_DPORT1,
	S3_MSSR0, // maximum segment size
	S3_MSSR1,
	S3_PROTO, // protocol in IP raw mode
	S3_TOS, // IP TOS
	S3_TTL, // IP TTL
	S3_TX_FSR0 = 0x0720, // Tx free size
	S3_TX_FSR1,
	S3_TX_RD0, // Tx read pointer
	S3_TX_RD1,
	S3_TX_WR0, // Tx write pointer
	S3_TX_WR1,
	S3_RX_RSR0, // Rx received size
	S3_RX_RSR1,
	S3_RX_RD0, // Rx read pointer
	S3_RX_RD1

} WIZnet5100_Register;

// S0_MR values
#define MR_CLOSE	  0x00    // Unused socket
#define MR_TCP		  0x01    // TCP
#define MR_UDP		  0x02    // UDP
#define MR_IPRAW	  0x03	  // IP LAYER RAW SOCK
#define MR_MACRAW	  0x04	  // MAC LAYER RAW SOCK
#define MR_PPPOE	  0x05	  // PPPoE
#define MR_ND		  0x20	  // No Delayed Ack(TCP) flag
#define MR_MULTI	  0x80	  // support multicating

// S0_CR values
#define CR_OPEN          0x01	  // Initialize or open socket
#define CR_LISTEN        0x02	  // Wait connection request in tcp mode(Server mode)
#define CR_CONNECT       0x04	  // Send connection request in tcp mode(Client mode)
#define CR_DISCON        0x08	  // Send closing reqeuset in tcp mode
#define CR_CLOSE         0x10	  // Close socket
#define CR_SEND          0x20	  // Update Tx memory pointer and send data
#define CR_SEND_MAC      0x21	  // Send data with MAC address, so without ARP process
#define CR_SEND_KEEP     0x22	  // Send keep alive message
#define CR_RECV          0x40	  // Update Rx memory buffer pointer and receive data

// S0_SR values
#define SOCK_CLOSED      0x00     // Closed
#define SOCK_INIT        0x13	  // Init state
#define SOCK_LISTEN      0x14	  // Listen state
#define SOCK_SYNSENT     0x15	  // Connection state
#define SOCK_SYNRECV     0x16	  // Connection state
#define SOCK_ESTABLISHED 0x17	  // Success to connect
#define SOCK_FIN_WAIT    0x18	  // Closing state
#define SOCK_CLOSING     0x1A	  // Closing state
#define SOCK_TIME_WAIT	 0x1B	  // Closing state
#define SOCK_CLOSE_WAIT  0x1C	  // Closing state
#define SOCK_LAST_ACK    0x1D	  // Closing state
#define SOCK_UDP         0x22	  // UDP socket
#define SOCK_IPRAW       0x32	  // IP raw mode socket
#define SOCK_MACRAW      0x42	  // MAC raw mode socket
#define SOCK_PPPOE       0x5F	  // PPPOE socket

//#define TXBUFADDR  0x4000      // W5100 Send Buffer Base Address
//#define RXBUFADDR  0x6000      // W5100 Read Buffer Base Address
#define MAX_BUF 2048 //512

#define TX_BUF_MASK      0x07FF   // Tx 2K Buffer Mask:
#define RX_BUF_MASK      0x07FF   // Rx 2K Buffer Mask:

extern void WIZnet5100_Init();

extern void WIZnet5100_SetGatewayAddress(const ipaddress_t ip);
extern void WIZnet5100_SetIpAddress(const ipaddress_t ip);
extern void WIZnet5100_SetSubnetMask(const subnetmask_t mask);
extern void WIZnet5100_GetMacAddress(macaddress_t* macaddress);
extern void WIZnet5100_GetIpAddress(ipaddress_t* ip);

extern bool WIZnet5100_FindAvailableSocket(uint8_t* socket);
extern bool WIZnet5100_ClaimSocket(uint8_t socket);
extern void WIZnet5100_ReleaseSocket(uint8_t socket);

extern uint16_t WIZnet5100_SocketRegisterOffset(uint8_t socket);
extern uint16_t WIZnet5100_SocketTransmitBufferAddress(uint8_t socket);
extern uint16_t WIZnet5100_SocketReceiveBufferAddress(uint8_t socket);
extern uint8_t WIZnet5100_Status(uint8_t socket);

extern uint8_t WIZnet5100_ReadByte(WIZnet5100_Register address);
extern void WIZnet5100_WriteByte(WIZnet5100_Register address, uint8_t data);

#endif /* WIZNET5100_H_ */
