/*
 * wiznet5100.c
 *
 *  Created on: May 24, 2011
 *      Author: Justin
 */
#include "stm32f10x.h"

#include "wiznet5100.h"

static ipaddress_t WIZNET_DEFAULT_IP = {0,0,0,0};
static bool _socketavailable[] = { TRUE, TRUE, TRUE, TRUE };

extern void WIZnet5100_Init()
{
	/* Enable clocks */
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1, ENABLE);

	/* GPIO configuration */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_StructInit(&GPIO_InitStructure);
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5|GPIO_Pin_6|GPIO_Pin_7;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2|GPIO_Pin_4;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	/*/Reset */
	GPIO_ResetBits(GPIOA, GPIO_Pin_2);

	/* SPI2 configuration */
	SPI_InitTypeDef SPI_InitStructure;
	SPI_StructInit(&SPI_InitStructure);
	SPI_InitStructure.SPI_Direction         = SPI_Direction_2Lines_FullDuplex; /* Duplex to use Rx Interrupt*/
	SPI_InitStructure.SPI_Mode              = SPI_Mode_Master;
	SPI_InitStructure.SPI_DataSize          = SPI_DataSize_8b;
	SPI_InitStructure.SPI_CPOL              = SPI_CPOL_Low;
	SPI_InitStructure.SPI_CPHA              = SPI_CPHA_1Edge;
	SPI_InitStructure.SPI_NSS               = SPI_NSS_Soft;    /* NSS Software Controlled */
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_64;
	SPI_InitStructure.SPI_FirstBit          = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial     = 7;
	SPI_Init(SPI1, &SPI_InitStructure);

	/* Enable SPI_MASTER */
	SPI_Cmd(SPI1, ENABLE);

	/* Take NSS line high by default */
	SPI_NSSInternalSoftwareConfig(SPI1, SPI_NSSInternalSoft_Set);

	/* clear /Reset */
	GPIO_SetBits(GPIOA, GPIO_Pin_2);

    /* Initialise WIZnet W5100 */
	WIZnet5100_WriteByte(MR, 0x80);

	macaddress_t mac = { 0x00, 0x16, 0x36, 0xDE, 0x58, 0xF6 };
	WIZnet5100_WriteByte(SHAR0, mac[0]);
	WIZnet5100_WriteByte(SHAR1, mac[1]);
	WIZnet5100_WriteByte(SHAR2, mac[2]);
	WIZnet5100_WriteByte(SHAR3, mac[3]);
	WIZnet5100_WriteByte(SHAR4, mac[4]);
	WIZnet5100_WriteByte(SHAR5, mac[5]);

	WIZnet5100_SetIpAddress(WIZNET_DEFAULT_IP);

	WIZnet5100_WriteByte(RMSR, 0x55);
	WIZnet5100_WriteByte(TMSR, 0x55);
}

extern void WIZnet5100_SetGatewayAddress(const ipaddress_t ip)
{
	WIZnet5100_WriteByte(GAR0, ip[0]);
	WIZnet5100_WriteByte(GAR1, ip[1]);
	WIZnet5100_WriteByte(GAR2, ip[2]);
	WIZnet5100_WriteByte(GAR3, ip[3]);
}

//extern void WIZnet5100_SetMacAddress(const macaddress_t mac)
//{
//	WIZnet5100_WriteByte(SHAR0, mac[0]);
//	WIZnet5100_WriteByte(SHAR1, mac[1]);
//	WIZnet5100_WriteByte(SHAR2, mac[2]);
//	WIZnet5100_WriteByte(SHAR3, mac[3]);
//	WIZnet5100_WriteByte(SHAR4, mac[4]);
//	WIZnet5100_WriteByte(SHAR5, mac[5]);
//}

extern void WIZnet5100_GetMacAddress(macaddress_t* macaddress)
{
	(*macaddress)[0] = WIZnet5100_ReadByte(SHAR0);
	(*macaddress)[1] = WIZnet5100_ReadByte(SHAR1);
	(*macaddress)[2] = WIZnet5100_ReadByte(SHAR2);
	(*macaddress)[3] = WIZnet5100_ReadByte(SHAR3);
	(*macaddress)[4] = WIZnet5100_ReadByte(SHAR4);
	(*macaddress)[5] = WIZnet5100_ReadByte(SHAR5);
}

extern void WIZnet5100_SetSubnetMask(const subnetmask_t mask)
{
	WIZnet5100_WriteByte(SUBR0, mask[0]);
	WIZnet5100_WriteByte(SUBR1, mask[1]);
	WIZnet5100_WriteByte(SUBR2, mask[2]);
	WIZnet5100_WriteByte(SUBR3, mask[3]);
}

extern void WIZnet5100_SetIpAddress(const ipaddress_t ip)
{
	WIZnet5100_WriteByte(SIPR0, ip[0]);
	WIZnet5100_WriteByte(SIPR1, ip[1]);
	WIZnet5100_WriteByte(SIPR2, ip[2]);
	WIZnet5100_WriteByte(SIPR3, ip[3]);
}

extern void WIZnet5100_GetIpAddress(ipaddress_t* ip)
{
	(*ip)[0] = WIZnet5100_ReadByte(SIPR0);
	(*ip)[1] = WIZnet5100_ReadByte(SIPR1);
	(*ip)[2] = WIZnet5100_ReadByte(SIPR2);
	(*ip)[3] = WIZnet5100_ReadByte(SIPR3);
}

extern bool WIZnet5100_FindAvailableSocket(uint8_t* socket)
{
	uint8_t index = 0;
	for (index = 0; index < 4; index++)
	{
		if (_socketavailable[index])
		{
			*socket = index;
			return TRUE;
		}
	}
	return FALSE;
}

extern bool WIZnet5100_ClaimSocket(uint8_t socket)
{
	if (_socketavailable[socket])
	{
		_socketavailable[socket] = FALSE;
		return TRUE;
	}

	return FALSE;
}

extern void WIZnet5100_ReleaseSocket(uint8_t socket)
{
	_socketavailable[socket] = TRUE;
}

extern uint16_t WIZnet5100_SocketRegisterOffset(uint8_t socket)
{
	 uint16_t offsets[] = { S0_MR - S0_MR, S1_MR - S0_MR, S2_MR - S0_MR, S3_MR - S0_MR };
	 return offsets[socket];
}

extern uint16_t WIZnet5100_SocketTransmitBufferAddress(uint8_t socket)
{
	 uint16_t addresses[] = { 0x4000, 0x4800, 0x5000, 0x5800 };
	 return addresses[socket];
}

extern uint16_t WIZnet5100_SocketReceiveBufferAddress(uint8_t socket)
{
	 uint16_t addresses[] = { 0x6000, 0x6800, 0x7000, 0x7800 };
	 return addresses[socket];
}

extern uint8_t WIZnet5100_Status(uint8_t socket)
{
	return WIZnet5100_ReadByte(WIZnet5100_SocketRegisterOffset(socket) + S0_SR);
}

static uint8_t WIZnet5100_SPISendReceive(SPI_TypeDef* SPIx, uint8_t byte)
{
	/* wait for transmit buffer to empty */
	//while (SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_BSY) == SET);
	while (SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_TXE) == RESET);

	SPI_I2S_SendData(SPIx, byte);

	/* wait for end of transmission */
	while (SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_TXE) == RESET);
	//while (SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_BSY) == SET);
    while (SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_RXNE) == RESET);

    return (uint8_t)(SPI_I2S_ReceiveData(SPIx) & 0x00FF);
}

extern uint8_t WIZnet5100_ReadByte(WIZnet5100_Register address)
{
	uint8_t result;

	/* wait for transmit buffer to empty */
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_TXE) == RESET);

	//nss_low()
	GPIO_ResetBits(GPIOA, GPIO_Pin_4);

	WIZnet5100_SPISendReceive(SPI1, 0x0F);
	WIZnet5100_SPISendReceive(SPI1, (uint8_t)((address & 0xFF00) >> 8));
	WIZnet5100_SPISendReceive(SPI1, (uint8_t)(address & 0x00FF));
	result = WIZnet5100_SPISendReceive(SPI1, 0x00); // dummy write

	//nss_high()
	GPIO_SetBits(GPIOA, GPIO_Pin_4);

	return result;
}

extern void WIZnet5100_WriteByte(WIZnet5100_Register address, uint8_t data)
{
	/* wait for transmit buffer to empty */
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_TXE) == RESET);

	//nss_low()
	GPIO_ResetBits(GPIOA, GPIO_Pin_4);

	WIZnet5100_SPISendReceive(SPI1, 0xF0);
	WIZnet5100_SPISendReceive(SPI1, (address & 0xFF00) >> 8);
	WIZnet5100_SPISendReceive(SPI1, (address & 0x00FF));
	WIZnet5100_SPISendReceive(SPI1, data);

	//nss_high()
	GPIO_SetBits(GPIOA, GPIO_Pin_4);
}
