/*
 * webserver.c
 *
 *  Created on: May 30, 2011
 *      Author: Justin
 */
#include "stm32f10x.h"

#include "webserver.h"
#include "http.h"
#include "tcp.h"
#include "dictionary.h"
#include "formdata.h"
#include "oauth.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WEBSERVER_HTML \
	"<html>"\
	"<body>"\
	"<form method='post'>"\
	"<h1>Tweeting Easy Button</h1>"\
	"<h3>Configuration Settings</h3>"\
	"<table>"\
	"<tr>"\
	"<td>Consumer Key</td>"\
	"<td><input type='text' name='consumerkey'/></td>"\
    "</tr>"\
    "<tr>"\
	"<td>Consumer Secret</td>"\
	"<td><input type='text' name='consumersecret'/></td>"\
    "</tr>"\
    "<tr>"\
	"<td>Token</td>"\
	"<td><input type='text' name='token'/></td>"\
    "</tr>"\
    "<tr>"\
	"<td>Token Secret</td>"\
	"<td><input type='text' name='tokensecret'/></td>"\
    "</tr>"\
    "</table>"\
    "<input type='submit' value='Set'/>"\
	"</form>"\
	"</body>"\
	"</html>"


//static void WebServer_HandleGet(const char* request);
//static void WebServer_HandlePost(const char* request);

extern bool WebServer_Init(uint8_t* socket)
{
	//Http_Init(0, WebServer_HandleGet, WebServer_HandlePost);

	return WIZnet5100_FindAvailableSocket(socket);
}

extern void WebServer_Check(uint8_t sockreg)
{
	uint8_t buf[2048];
	//int tempvalue;
	//uint8_t ledmode;

	uint8_t sockstat;
	uint16_t rsize;

	sockstat = WIZnet5100_Status(sockreg);

	switch(sockstat)
	{
	case SOCK_CLOSED:
		if (Tcp_Open(sockreg,80) > 0)
		{
			// Listen to Socket 0
			Tcp_Listen(sockreg);
			//if (WIZnet5100_Listen(sockreg) <= 0)
			//_delay_ms(1);
		}
		break;

	case SOCK_ESTABLISHED:
		// Get the client request size
		rsize=Tcp_GetReceivedBytes(sockreg);

		if (rsize > 0)
		{
			memset(buf, 0, 2048);

			// Now read the client Request
			if (Tcp_Receive(sockreg,buf,rsize) <= 0) break;

			httpmethod_t method = Http_GetRequestMethod((char*)buf);
			if (method == HTTP_GET || method == HTTP_POST)
			{
				if (method == HTTP_POST)
				{
					uint16_t postdatasize = Http_GetContentLength((char*)buf);
					char* postdata = (char*)malloc(postdatasize + 1);
					Http_GetContent((char*)buf, postdata, postdatasize);

					dictionary_t dictionary;
					Dictionary_Init(&dictionary);

					Formdata_Decode(postdata, &dictionary);
					Oauth_Init(Dictionary_GetEntry(&dictionary, "consumerkey")->Value,
							   Dictionary_GetEntry(&dictionary, "consumersecret")->Value,
							   Dictionary_GetEntry(&dictionary, "token")->Value,
							   Dictionary_GetEntry(&dictionary, "tokensecret")->Value);

					free(postdata);
				}

				// Now Send the HTTP Remaining Response
				strcpy((char*)buf, WEBSERVER_HTML);
				if (Tcp_Send(sockreg,buf,strlen((char*)buf)) <= 0) break;
			}

			// Disconnect the socket
			Tcp_Disconnect(sockreg);
		}
		//else
		//  _delay_us(10);    // Wait for request
		break;
	case SOCK_FIN_WAIT:
	case SOCK_CLOSING:
	case SOCK_TIME_WAIT:
	case SOCK_CLOSE_WAIT:
	case SOCK_LAST_ACK:
		// Force to close the socket
		Tcp_Close(sockreg);
		break;
    }
}

static void WebServer_HandleGet(const char* request)
{
	uint8_t buffer[2048];
	// Create the HTTP Response	Header
	strcpy((char*)buffer,"HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n\r\n");
	strcat((char*)buffer,"<html><body><span style=\"color:#0000A0\">\r\n");
	strcat((char*)buffer,"<h1>Embedded Web Server</h1>\r\n");
	strcat((char*)buffer,"<h3>STM32F103RG and WIZ811MJ</h3>\r\n");
	strcat((char*)buffer,"<p><form method=\"POST\">\r\n");
	// Now Send the HTTP Response
	//if (Tcp_Send(sockreg,buf,strlen((char *)buf)) <= 0) break;

	// Create the HTTP Temperature Response
	//sprintf((char *)temp,"%d",tempvalue);        // Convert temperature value to string
	//strcpy_P((char *)buf,PSTR("<strong>Temp: <input type=\"text\" size=2 value=\""));
	//strcat((char *)buf,temp);
	//strcat_P((char *)buf,PSTR("\"> <sup>O</sup>C\r\n"));

	//if (ledmode == 1)
	//{
	//    strcpy(radiostat0,"");
	//    strcpy_P(radiostat1,PSTR("checked"));
	//}
	//else
	//{
	//    strcpy_P(radiostat0,PSTR("checked"));
	//    strcpy(radiostat1,"");
	//}
		// Create the HTTP Radio Button 0 Response
	//strcat_P((char *)buf,PSTR("<p><input type=\"radio\" name=\"radio\" value=\"0\" "));
	//strcat((char *)buf,radiostat0);
	//strcat_P((char *)buf,PSTR(">Blinking LED\r\n"));
	//strcat_P((char *)buf,PSTR("<br><input type=\"radio\" name=\"radio\" value=\"1\" "));
	//strcat((char *)buf,radiostat1);
	//strcat_P((char *)buf,PSTR(">Scanning LED\r\n"));
	//strcat_P((char *)buf,PSTR("</strong><p>\r\n"));
	strcat((char*)buffer,"<input type=\"submit\">\r\n");
	strcat((char*)buffer,"</form></span></body></html>\r\n");
		// Now Send the HTTP Remaining Response
    Tcp_Send(0, buffer, strlen((char*)buffer));
}

extern void WebServer_HandlePost(const char* request)
{

}
