/*
 * udp.h
 *
 *  Created on: May 30, 2011
 *      Author: Justin
 */

#ifndef UDP_H_
#define UDP_H_

#include <stddef.h>
#include "stm32f10x.h"

#include "wiznet5100.h"

extern bool Udp_OpenAvailableSocket(uint16_t port, uint8_t* socket);
extern bool Udp_Open(uint8_t socket, uint16_t port);
extern bool Udp_Send(uint8_t socket, ipaddress_t ip, uint16_t port, const uint8_t* buf, uint16_t buflen);
extern bool Udp_Receive(uint8_t socket, ipaddress_t* ip, uint16_t* port, uint8_t* buf, uint16_t buflen);
extern void Udp_Close(uint8_t socket);

extern uint16_t Udp_GetReceivedSize(uint8_t socket);

#endif /* UDP_H_ */
