/*
 * twitter.h
 *
 *  Created on: Jun 5, 2011
 *      Author: Justin
 */

#ifndef TWITTER_H_
#define TWITTER_H_

#include "stm32f10x.h"

typedef void (*twittercallback_t)(uint16_t statuscode, const char* reason);

extern void Twitter_RegisterCallback(twittercallback_t callback);

extern bool Twitter_GetAuthorizationUrl(char* url, uint16_t size);
extern bool Twitter_LoadAuthorizedToken(const char* token);
extern bool Twitter_Tweet(const char* message);

#endif /* TWITTER_H_ */
