/*
 * twitter.c
 *
 *  Created on: Jun 5, 2011
 *      Author: Justin
 */

#include "stm32f10x.h"

#include "twitter.h"
#include "oauth.h"
#include "http.h"
#include "dictionary.h"
#include "nokia5110.h"

#include <stdlib.h>
#include <string.h>

#define TWITTER_REQUESTTOKEN "http://api.twitter.com/oauth/request_token"
#define TWITTER_AUTHORIZE    "http://api.twitter.com/oauth/authorize"
#define TWITTER_ACCESSTOKEN  "http://api.twitter.com/oauth/access_token"
#define TWITTER_STATUS       "http://twitter.com/statuses/update.xml"

static twittercallback_t _twitter_callback = 0;

extern void Twitter_RegisterCallback(twittercallback_t callback)
{
	_twitter_callback = callback;
}

extern bool Twitter_GetAuthorizationUrl(char* url, uint16_t size)
{
	uint8_t socket;
	if (!Oauth_Get(TWITTER_REQUESTTOKEN, &socket))
	{
		return FALSE;
	}

	uint16_t retrys = 1000;
	while (retrys--)
	{
		uint16_t size = Oauth_GetReceivedBytes(socket);
		if (size > 0)
		{
			char* buffer = (char*)malloc(size);

			Oauth_GetResponse(socket, buffer, size);
			// todo - parse response

			free(buffer);

			Oauth_Close(socket);
			return TRUE;
		}
	}

	Oauth_Close(socket);
	return FALSE;
}

extern bool Twitter_LoadAuthorizedToken(const char* token)
{
	uint8_t socket;
	if (!Oauth_Get(TWITTER_ACCESSTOKEN, &socket))
	{
		return FALSE;
	}

	uint16_t retrys = 1000;
	while (retrys--)
	{
		uint16_t size = Oauth_GetReceivedBytes(socket);
		if (size > 0)
		{
			char* buffer = (char*)malloc(size);

			Oauth_GetResponse(socket, buffer, size);
			// todo - parse response

			free(buffer);

			Oauth_Close(socket);
		    return TRUE;
		}
	}

	Oauth_Close(socket);
	return FALSE;
}

extern bool Twitter_Tweet(const char* message)
{
	uint8_t socket;

	dictionary_t postdata;
	Dictionary_Init(&postdata);

	Dictionary_Add(&postdata, "status", message);

	if (!Oauth_Post(TWITTER_STATUS, &postdata, &socket))
	{
		if (_twitter_callback != 0)
		{
			_twitter_callback(600, "Send failed");
		}
		return FALSE;
	}

	uint16_t retrys = 10000;
	while (retrys--)
	{
		uint16_t size = Oauth_GetReceivedBytes(socket);
		if (size > 0)
		{
			char* buffer = (char*)malloc(size);

			Oauth_GetResponse(socket, buffer, size);
			// todo - parse response
			uint16_t statuscode = Http_GetResponseStatusCode(buffer);
			if (_twitter_callback != 0)
			{
				char reason[15];
				Http_GetResponseReason(buffer, reason, 14);
				_twitter_callback(statuscode, reason);
			}

			free(buffer);

			Oauth_Close(socket);
			return statuscode == 200;
		}
	}

	if (_twitter_callback != 0)
	{
		_twitter_callback(601, "Timeout");
	}
	Oauth_Close(socket);
	return FALSE;
}
