/*
 * tcp.h
 *
 *  Created on: May 30, 2011
 *      Author: Justin
 */

#ifndef TCP_H_
#define TCP_H_

#include "stm32f10x.h"

#include "wiznet5100.h"

extern bool Tcp_OpenAvailableSocket(uint16_t port, uint8_t* socket);
extern bool Tcp_Open(uint8_t socket, uint16_t tcp_port);
extern bool Tcp_Connect(uint8_t socket, const ipaddress_t ip, uint16_t port);
extern bool Tcp_Listen(uint8_t socket);
extern bool Tcp_Send(uint8_t socket, const uint8_t *buf, uint16_t buflen);
extern bool Tcp_Receive(uint8_t socket,uint8_t *buf,uint16_t buflen);
extern void Tcp_Close(uint8_t socket);
extern void Tcp_Disconnect(uint8_t socket);

extern uint16_t Tcp_GetReceivedBytes(uint8_t socket);

#endif /* TCP_H_ */
