/*
 * sntp.c
 *
 *  Created on: Jun 2, 2011
 *      Author: Justin
 */
#include "stm32f10x.h"

#include "sntp.h"
#include "dns.h"
#include "udp.h"

#include <stdlib.h>
#include <string.h>

#define SNTP_PACKETSIZE 48

#define SNTP_PORT 123
#define SNTP_TIMESERVER "time.nist.gov"

extern bool Sntp_GetTime(uint32_t* time)
{
	bool result = FALSE;

	ipaddress_t ip;
	if (!Dns_Lookup(SNTP_TIMESERVER, &ip))
	{
		return result;
	}

	uint8_t socket;
	if (!Udp_OpenAvailableSocket(SNTP_PORT, &socket))
	{
		return result;
	}

	uint8_t packet[SNTP_PACKETSIZE];
	memset(packet, 0, SNTP_PACKETSIZE);

	packet[0] = 0x0B;

	if (!Udp_Send(socket, ip, SNTP_PORT, packet, SNTP_PACKETSIZE))
	{
		Udp_Close(socket);
		return result;
	}

	uint16_t failures = 100;
	while(failures)
	{
		uint16_t size = Udp_GetReceivedSize(socket);
		if (size >= SNTP_PACKETSIZE)
		{
			uint8_t* response = (uint8_t*)malloc(size);
			ipaddress_t fromip;
			uint16_t fromport;
			if (!Udp_Receive(socket, &fromip, &fromport, response, size))
			{
				break;
			}

			//uint8_t li_vn_mode = response[0];
			//uint8_t stratum = response[1];
			//uint8_t poll = response[2];
			//uint8_t precision = response[3];

			/* root delay
			uint32_t rootdelay = ((uint32_t)(response[4]) << 24) +
					             ((uint32_t)(response[5]) << 16) +
					             ((uint32_t)(response[6]) << 8) +
					             ((uint32_t)(response[7]));
			*/

			/* root dispersion
			uint32_t rootdispersion = ((uint32_t)(response[8]) << 24) +
								      ((uint32_t)(response[9]) << 16) +
								      ((uint32_t)(response[10]) << 8) +
								      ((uint32_t)(response[11]));
			*/

			/* reference identifier
			uint32_t referenceidentifier = ((uint32_t)(response[12]) << 24) +
								           ((uint32_t)(response[13]) << 16) +
								           ((uint32_t)(response[14]) << 8) +
								           ((uint32_t)(response[15]));
			*/

			/* reference timestamp
			uint32_t referencetimestamp = ((uint32_t)(response[16]) << 24) +
								          ((uint32_t)(response[17]) << 16) +
								          ((uint32_t)(response[18]) << 8) +
								          ((uint32_t)(response[19]));
			*/

			/* reference timestamp (fraction)
			uint32_t referencetimestamp_fraction = ((uint32_t)(response[20]) << 24) +
								                   ((uint32_t)(response[21]) << 16) +
								                   ((uint32_t)(response[22]) << 8) +
								                   ((uint32_t)(response[23]));
			*/

			/* originate timestamp
			uint32_t originatetimestamp = ((uint32_t)(response[24]) << 24) +
										  ((uint32_t)(response[25]) << 16) +
										  ((uint32_t)(response[26]) << 8) +
										  ((uint32_t)(response[27]));
			*/

			/* originate timestamp (fraction)
			uint32_t originatetimestamp_fraction = ((uint32_t)(response[28]) << 24) +
												   ((uint32_t)(response[29]) << 16) +
												   ((uint32_t)(response[30]) << 8) +
												   ((uint32_t)(response[31]));
			*/

			/* receive timestamp
			uint32_t receivetimestamp = ((uint32_t)(response[32]) << 24) +
							            ((uint32_t)(response[33]) << 16) +
								        ((uint32_t)(response[34]) << 8) +
								        ((uint32_t)(response[35]));
		    */

			/* receive timestamp (fraction)
			uint32_t receivetimestamp_fraction = ((uint32_t)(response[36]) << 24) +
							                     ((uint32_t)(response[37]) << 16) +
								                 ((uint32_t)(response[38]) << 8) +
								                 ((uint32_t)(response[39]));
	        */

			// to UNIX time subtract 2208988800
			*time = ((uint32_t)(response[40]) << 24) +
				    ((uint32_t)(response[41]) << 16) +
					((uint32_t)(response[42]) << 8) +
					((uint32_t)(response[43])) - 2208988800ul;

			/* transmit timestamp (fraction)
			uint32_t transmittimestamp_fraction = ((uint32_t)(response[44]) << 24) +
												  ((uint32_t)(response[45]) << 16) +
												  ((uint32_t)(response[46]) << 8) +
												  ((uint32_t)(response[47]));
			*/

			result = TRUE;
			break;
		}
	}

    Udp_Close(socket);
    return result;
}
