/*
 * oauth.h
 *
 *  Created on: Jun 5, 2011
 *      Author: Justin
 */

#ifndef OAUTH_H_
#define OAUTH_H_

#include "stm32f10x.h"

#include "dictionary.h"

extern void Oauth_Init(const char* consumerkey, const char* consumersecret, const char* token, const char* tokensecret);
extern bool Oauth_IsInitialized();
extern bool Oauth_Get(const char* url, uint8_t* socket);
extern bool Oauth_Post(const char* url, dictionary_t* postdata, uint8_t* socket);
extern uint16_t Oauth_GetReceivedBytes(uint8_t socket);
extern bool Oauth_GetResponse(uint8_t socket, char* buffer, uint16_t buffersize);
extern void Oauth_Close(uint8_t socket);

#endif /* OAUTH_H_ */
