/*
 * interrupts.h
 *
 *  Created on: Jun 23, 2011
 *      Author: Justin
 */

#ifndef INTERRUPTS_H_
#define INTERRUPTS_H_

/* Exported types ------------------------------------------------------------*/
typedef void (*Interrupts_Callback)();

typedef enum
{
	INTERRUPTS_TIM2,
	INTERRUPTS_RTC,
	INTERRUPTS_SysTick,
	INTERRUPTS_RTCAlarm,
	INTERRUPTS_ADC,
	INTERRUPTS_SourcesEnd

} Interrupts_Sources;

/* Exported function prototypes ----------------------------------------------*/

// Interrupts_RegisterCallback()
// -----------------------------
// Register an event handler for a given interrupt source
// Note: current implementation allows for only one handler per interrupt source
extern void Interrupts_RegisterCallback(Interrupts_Sources source, Interrupts_Callback callback);

// Interrupts_UnregisterCallback()
// -----------------------------
// Unregister the current event handler for a given interrupt source
extern void Interrupts_UnregisterCallback(Interrupts_Sources source);

#endif /* INTERRUPTS_H_ */
