/*
 * http.h
 *
 *  Created on: May 30, 2011
 *      Author: Justin
 */

#ifndef HTTP_H_
#define HTTP_H_

#include "stm32f10x.h"

typedef void (*Http_GetFunc)(const char* request);
typedef void (*Http_PostFunc)(const char* request);

extern void Http_Init(uint8_t socket, Http_GetFunc getfunc, Http_PostFunc postfunc);
extern void Http_Check(uint8_t socket);

extern bool Http_Get(const char* url, uint8_t* socket);
extern bool Http_Post(const char* url, const char* contenttype, uint8_t* content, uint16_t contentlength, uint8_t* socket);

extern uint16_t Http_GetReceivedBytes(uint8_t socket);
extern uint16_t Http_GetResponse(uint8_t socket, char* buffer, uint16_t size);

extern void Http_Close(uint8_t socket);

typedef enum
{
	HTTP_UnknownMethod,
    HTTP_GET,
	HTTP_HEAD,
	HTTP_POST,
	HTTP_PUT,
	HTTP_DELETE,
	HTTP_TRACE,
	HTTP_CONNECT

} httpmethod_t;

typedef enum
{
	HTTP_UnknownVersion,
    HTTP_1_0,
    HTTP_1_1

} httpversion_t;

extern httpmethod_t  Http_GetRequestMethod(const char* request);
extern uint16_t      Http_GetRequestURL(const char* request, char* result, uint16_t size);
extern httpversion_t Http_GetRequestVersion(const char* request);

extern httpversion_t Http_GetResponseVersion(const char* response);
extern uint8_t       Http_GetResponseStatusCode(const char* response);
extern uint16_t      Http_GetResponseReason(const char* response, char* result, uint16_t size);

extern uint16_t Http_GetContentType(const char* request, char* result, uint16_t size);
extern uint16_t Http_GetContentLength(const char* request);
extern uint16_t Http_GetContent(const char* request, char* result, uint16_t size);

#endif /* HTTP_H_ */
