/*
 * hmacsha1.c
 *
 *  Created on: Jun 3, 2011
 *      Author: Justin
 */

#include "stm32f10x.h"

#include "hmacsha1.h"
#include "sha1.h"

#include <stdint.h>
#include <string.h>

#define IPAD 0x36
#define OPAD 0x5C

/*
 * keylength in bits!
 * message length in bits!
 */
void hmac_sha1(void* dest, const void* key, uint16_t keylength_b, const void* msg, uint32_t msglength_b)
{
	/* a one-shot*/
    sha1_ctx_t s;
    uint8_t i;
    uint8_t buffer[SHA1_BLOCK_BYTES];

    memset(buffer, 0, SHA1_BLOCK_BYTES);

    /* if key is larger than a block we have to hash it*/
    if (keylength_b > SHA1_BLOCK_BITS)
    {
        sha1((void*)buffer, key, keylength_b);
    }
    else
    {
        memcpy(buffer, key, (keylength_b+7)/8);
    }

    for (i=0; i<SHA1_BLOCK_BYTES; ++i)
    {
        buffer[i] ^= IPAD;
    }
    sha1_init(&s);
    sha1_nextBlock(&s, buffer);
    while (msglength_b >= SHA1_BLOCK_BITS)
    {
        sha1_nextBlock(&s, msg);
        msg = (uint8_t*)msg + SHA1_BLOCK_BYTES;
        msglength_b -=  SHA1_BLOCK_BITS;
    }
    sha1_lastBlock(&s, msg, msglength_b);
    /* since buffer still contains key xor ipad we can do ... */
    for (i=0; i<SHA1_BLOCK_BYTES; ++i)
    {
        buffer[i] ^= IPAD ^ OPAD;
    }
    sha1_ctx2hash(dest, &s); /* save inner hash temporary to dest */
    sha1_init(&s);
    sha1_nextBlock(&s, buffer);
    sha1_lastBlock(&s, dest, SHA1_HASH_BITS);
    sha1_ctx2hash(dest, &s);
}
