/*
 * easybutton.c
 *
 *  Created on: Jun 23, 2011
 *      Author: Justin
 */

#include "stm32f10x.h"
#include "easybutton.h"

#define EASYBUTTON_Clock RCC_APB2Periph_GPIOA
#define EASYBUTTON_Port  GPIOA
#define EASYBUTTON_Pin   GPIO_Pin_1

// EasyButton_Init()
// -----------------
// Initialize the easy button module.
extern void EasyButton_Init()
{
	RCC_APB2PeriphClockCmd(EASYBUTTON_Clock, ENABLE);

	/* Configure button pin as input pull down ------------------------------*/
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin = EASYBUTTON_Pin;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;
	GPIO_Init(EASYBUTTON_Port, &GPIO_InitStructure);
}

// EasyButton_IsPressed()
// ----------------------
// Determine if the easy button is pressed.
extern bool EasyButton_IsPressed()
{
	return GPIO_ReadInputDataBit(EASYBUTTON_Port, EASYBUTTON_Pin) != 0;
}
