/*
 * namevaluecollection.h
 *
 *  Created on: May 27, 2011
 *      Author: Justin
 */

#ifndef DICTIONARY_H_
#define DICTIONARY_H_

#include "stm32f10x.h"

typedef struct
{
    char* Name;
    char* Value;
    void* Next;

} dictionaryentry_t;

typedef struct
{
    dictionaryentry_t* Start;

} dictionary_t;

extern void Dictionary_Init(dictionary_t* dictionary);
extern void Dictionary_Free(dictionary_t* dictionary);

extern dictionaryentry_t* Dictionary_Add(dictionary_t* dictionary, const char* name, const char* value);
extern dictionaryentry_t* Dictionary_GetFirst(const dictionary_t* dictionary);
extern dictionaryentry_t* Dictionary_GetNext(const dictionaryentry_t* entry);
extern dictionaryentry_t* Dictionary_GetEntry(const dictionary_t* dictionary, const char* name);
extern uint16_t Dictionary_Get(const dictionary_t* dictionary, const char* name, char* result, uint16_t size);

#endif /* DICTIONARY_H_ */
