/*
 * dictionary.c
 *
 *  Created on: Jun 5, 2011
 *      Author: Justin
 */

#include "stm32f10x.h"

#include "dictionary.h"

#include <stdlib.h>
#include <string.h>

extern void Dictionary_Init(dictionary_t* dictionary)
{
	dictionary->Start = 0;
}

extern void Dictionary_Free(dictionary_t* dictionary)
{
    while(dictionary->Start)
    {
        dictionaryentry_t* temp = dictionary->Start;
        dictionary->Start = temp->Next;
        free(temp->Name);
        free(temp->Value);
        free(temp);
    }
}

extern dictionaryentry_t* Dictionary_Add(dictionary_t* dictionary, const char* name, const char* value)
{
    dictionaryentry_t* item = (dictionaryentry_t*)malloc(sizeof(dictionaryentry_t));
    item->Name = (char*)malloc(strlen(name) + 1);
    strcpy(item->Name, name);

    item->Value = (char*)malloc(strlen(value) + 1);
    strcpy(item->Value, value);

    if (dictionary->Start == 0)
    {
        item->Next = 0;

        dictionary->Start = item;
        return item;
    }

    if (strcmp(dictionary->Start->Name, name) > 0)
    {
    	item->Next = dictionary->Start;
    	dictionary->Start = item;
    	return item;
    }

    dictionaryentry_t* ptr = dictionary->Start;
    while (ptr->Next != 0 && strcmp(((dictionaryentry_t*)(ptr->Next))->Name, name) < 0)
    {
        ptr = ptr->Next;
    }

    item->Next = ptr->Next;
    ptr->Next = item;
    return item;
}

extern dictionaryentry_t* Dictionary_GetFirst(const dictionary_t* dictionary)
{
    return dictionary->Start;
}

extern dictionaryentry_t* Dictionary_GetNext(const dictionaryentry_t* item)
{
    return item->Next;
}

extern dictionaryentry_t* Dictionary_GetEntry(const dictionary_t* dictionary, const char* name)
{
	dictionaryentry_t* entry = Dictionary_GetFirst(dictionary);
	while (entry != 0)
	{
		if (strcmp(name, entry->Name) == 0)
		{
			return entry;
		}

		entry = Dictionary_GetNext(entry);
	}

	return 0;
}

extern uint16_t Dictionary_Get(const dictionary_t* dictionary, const char* name, char* result, uint16_t size)
{
	dictionaryentry_t* entry = Dictionary_GetEntry(dictionary, name);
	if (entry == 0)
	{
		if (result != 0)
		{
			strncpy(result, entry->Value, size);
		}
		return strlen(entry->Value);
	}

	return 0;
}
