#include "stm32f10x.h"

#include "base64.h"

#include <string.h>

static const char* base64_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                  "abcdefghijklmnopqrstuvwxyz"
                                  "0123456789+/";

// inputsize is size of the input array in bytes
// outputsize is the allocated size of the output string (including null terminator)
//
// return value of false indicates an error condition
// on return outputlength is number of characters placed in the output string or...
//
// to determine the required string size set output = NULL
// the required allocation size will be outputsize
extern uint16_t Base64_Encode(const unsigned char* input, uint16_t inputsize, char* output, uint16_t outputsize)
{
	int in_len = inputsize;
    int i = 0;
    int j = 0;
    unsigned char char_array_3[3];
    unsigned char char_array_4[4];

    int index = 0;

    while (in_len--) 
    {
        char_array_3[i++] = *(input++);
        if (i == 3) 
		{
            char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
            char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
            char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
            char_array_4[3] = char_array_3[2] & 0x3f;

            for(i = 0; (i <4) ; i++)
			{
                //ret += base64_chars[char_array_4[i]];
				if (output != NULL)
		        {
					if (index >= (outputsize - 1))
					{
						// invalid output buffer size
						return 0;
					}

                    output[index] = base64_chars[char_array_4[i]];
					output[index + 1] = '\0';
		        }
		        index++;
			}

            i = 0;
        }
    }

    if (i)
    {
        for(j = i; j < 3; j++)
		{
            char_array_3[j] = '\0';
		}

        char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
        char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
        char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
        char_array_4[3] = char_array_3[2] & 0x3f;

        for (j = 0; (j < i + 1); j++)
		{
            //ret += base64_chars[char_array_4[j]];
			if (output != NULL)
		    {
			    if (index >= (outputsize - 1))
				{
					// invalid output buffer size
					return 0;
				}

                output[index] = base64_chars[char_array_4[j]];
				output[index + 1] = '\0';
			}
		    index++;
		}

        while((i++ < 3))
		{			
            //ret += '=';
			if (output != NULL)
		    {
			    if (index >= (outputsize - 1))
				{
					// invalid output buffer size
					return 0;
				}

                output[index] = '=';
				output[index + 1] = '\0';
			}
		    index++;
		}
    }

	return index + 1;
}

// outputsize is the number of bytes allocated for output
//
// a return value of false indicates an error condition
// on return outputsize is number of bytes placed in the output array or...
//
// to determine the required array size set output = NULL
// the required array size will be the returned in the output size parameter
extern uint16_t Base64_Decode(const char* input, unsigned char* output, uint16_t outputsize)
{
    int in_len = strlen(input);
    int i = 0;
    int j = 0;
    int in_ = 0;
    unsigned char char_array_4[4], char_array_3[3];  

    int index = 0;

    while (in_len-- && (input[in_] != '=')) 
    {
        char_array_4[i++] = input[in_]; in_++;
        if (i == 4) 
		{
            for (i = 0; i < 4; i++)
			{
                char_array_4[i] = strchr(base64_chars, char_array_4[i]) - base64_chars;
			}

            char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
            char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
            char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

            for (i = 0; (i < 3); i++)
	        {
		        if (output != NULL)
		        {
					if (index >= outputsize)
					{
						// invalid output buffer size
						return 0;
					}

                    output[index] = char_array_3[i];
		        }
		        index++;
	        }
            i = 0;
        }
    }

    if (i) 
	{
        for (j = i; j < 4; j++)
		{
            char_array_4[j] = 0;
		}

        for (j = 0; j < 4; j++)
		{
            char_array_4[j] = strchr(base64_chars, char_array_4[j]) - base64_chars;
		}

        char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
        char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
        char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

        for (j = 0; (j < i - 1); j++)
	    {
		    if (output != NULL)
		    {
				if (index >= outputsize)
				{
					// invalid output buffer size
					return 0;
				}

		        output[index] = char_array_3[j];
		    }
		    index++;
	    }
    }

	return index;
}
