//
// This is a helper program for visualizing the results of the variSlice.pde Sketch
// Writtem by Steve Kranz at Autodesk, Pier 9, San Francisco, 2016.
// This code is licensed with Creative Commons Attribution 3.0
//

Table drawData;
int layerLocal;
int heightLocal;
float scale = 0.1;


void setup(){
  size(1000,2500); // 1 pixel = 10 µm. Width value is unimportant. Only height needs to be changed. Here, the dumbbell3.stl is 25 mm tall, so this image should be 2500 pixels tall. Aliasing can be an issue since layers are in 5 µm increments.
  drawData = loadTable("drawDatadumb-100-10.csv", "header");
  noLoop();
  background(255);
  noSmooth();
  colorMode(HSB, 360, 100, 100);
}


void draw(){
  stroke(70);
  fill(180);
  rectMode(CENTER);
  float thickHue = 0;     // degrees
  float thinHue = 240;    // degrees
  float thickLayer = 100; // microns
  float thinLayer = 5;   // microns
 
  color layerColor;
  float layerHue;
  float layerBri;

  for(int k = 0; k<drawData.getRowCount(); k++){
    TableRow tempRow = drawData.getRow(k);

    // This gives alternating layers different brightness so adjacent layers with the same thickness will be distinguishable.
    if(k%2==0){
      layerBri = 200;
    } else {
      layerBri = 60;
    }
    
    layerHue = map(log(tempRow.getInt("Thickness")), log(thinLayer), log(thickLayer), thinHue, thickHue);
   
    color color1 = color(41, 60, 92);
    color color2 = color(268, 37, 31);
   
    layerColor = color(layerHue, 50, layerBri);

    fill(layerColor);
    noStroke();
    rect(width/2, height-(tempRow.getFloat("Height")*scale)+tempRow.getInt("Thickness")*scale/2, width, tempRow.getInt("Thickness")*scale);   
  }

  saveFrame("layersVisualized/"+year()+month()+day()+"-"+hour()+";"+minute()+";"+second()+".png");
  exit(); 
}


