// Functions for power management

// Utility macros
#define adc_disable() (ADCSRA &= ~(1<<ADEN)) // disable ADC
#define adc_enable()  (ADCSRA |=  (1<<ADEN)) // re-enable ADC

void sleepNow()
{
  // Turn off PWM pins.
  // Turn off pullup resistor for color pin.
  pinMode(yellowPWMPin, INPUT);
  pinMode(yellowButtonPin, INPUT);
  delay(debounceDelay);

  // Go to sleep
  adc_disable(); // Disable ADC to save energy.
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);   // Sleep mode with the most power saving.
  sleep_enable();          // Enables the sleep bit in the mcucr register.
  attachInterrupt(0, wakeUpNow, LOW); // Use interrupt 0 (pin 2) and run function.
  sleep_mode();     // The chip is put to sleep here.

  // Wake up
  sleep_disable(); // When button is pressed, wake up.
  detachInterrupt(0); // disables interrupt 0 on pin 2 to prevent executing wakeUpNow while running.
  adc_enable();

  // Turn on PWM pins.
  // Turn on pullup resistor for color pin.
  pinMode(yellowPWMPin, OUTPUT);
  pinMode(yellowButtonPin, INPUT_PULLUP);
  TCCR0A = _BV(COM0B1) | _BV(WGM01) | _BV(WGM00);
  TCCR0B = _BV(WGM02) | _BV(CS00);

  yellowOnTime = 0;
  OCR0A = maxOnTime;
  OCR0B = 0;

  powerButtonState = LOW;
  delayCounts = timeHold(powerButtonPin, powerButtonState);

  if (delayCounts <= 2) { // If short pressed, go back to sleep. Prevents accidental use.
    sleepNow();
  }
}

void wakeUpNow() // Required for the interrupt for waking up.
{
  // No code will be run here.
}




