int delayCounts;

boolean powerButtonState;
boolean redButtonState;
boolean yellowButtonState;
boolean whiteButtonState;


void readButtons() {
  powerButtonState = digitalRead(powerButtonPin);
  yellowButtonState = digitalRead(yellowButtonPin);

  if (powerButtonState == LOW) {
    delayCounts = timeHold(powerButtonPin, powerButtonState);

    if (delayCounts <= 2) { // If short pressed, increment mode and store it in EEPROM.
      modeNumber = incrementCounter(modeAddr, modeNumber, modeTop);
      updateSettings();
    }
    else if (delayCounts > 2) { // If long pressed, go to sleep.    
      sleepNow();
    }
  }

  if (yellowButtonState == LOW) {
    delayCounts = timeHold(yellowButtonPin, yellowButtonState);

    if (delayCounts <= 2) { // If short pressed, increment pattern and store it in EEPROM.
      yellowPatterns[modeNumber] = incrementCounter(yellowPatternAddrs[modeNumber], yellowPatterns[modeNumber], patternTop);
      updateSettings();
    }
    else if (delayCounts > 2) { // If long pressed, increment brightness and store it in EEPROM.
      yellowIntensities[modeNumber] = incrementCounter(yellowIntensityAddrs[modeNumber], yellowIntensities[modeNumber], brightnessTop);
      updateSettings();
    }
  }
}

// Increment setting counters.
byte incrementCounter(byte address, byte value, byte top) {

  if (value < top) {
    value++;
  }
  else if(value>=top){
    value = 0;
  }
  EEPROM.write(address, value);
  return value;
}

// Time how long button was pressed for.
byte timeHold(byte buttonPin, boolean buttonState) {
  byte counts = 0;
  yellowOnTime = 0;
  OCR0B = 0;
  
  while (buttonState == LOW) { // While the button is pressed, count how long it was pressed.
    delay(debounceDelay);
    counts++;
    buttonState = digitalRead(buttonPin);
  }
  return counts;
}

